/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.filter.RuleManager;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jsieve.parser.generated.Node;
import org.apache.jsieve.parser.generated.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyFilterRules
extends MailDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ArrayList<Integer> affectedIds;
        ArrayList<Integer> messageIds;
        Mailbox mbox;
        Node node;
        ZimbraSoapContext zsc;
        block25: {
            Account account;
            zsc = ApplyFilterRules.getZimbraSoapContext(context);
            if (!this.canAccessAccount(zsc, account = ApplyFilterRules.getRequestedAccount(zsc))) {
                throw ServiceException.PERM_DENIED("cannot access account");
            }
            String fullScript = RuleManager.getRules(account);
            if (StringUtil.isNullOrEmpty(fullScript)) {
                throw ServiceException.INVALID_REQUEST("Account has no filter rules defined.", null);
            }
            List<Element> ruleElements = request.getElement("filterRules").listElements("filterRule");
            if (ruleElements.size() == 0) {
                String msg = String.format("No %s elements specified.", "filterRule");
                throw ServiceException.INVALID_REQUEST(msg, null);
            }
            StringBuilder buf = new StringBuilder();
            for (Element ruleEl : ruleElements) {
                String name = ruleEl.getAttribute("name");
                String singleRule = RuleManager.getRuleByName(fullScript, name);
                if (singleRule == null) {
                    String msg = String.format("Could not find a rule named '%s'", name);
                    throw ServiceException.INVALID_REQUEST(msg, null);
                }
                buf.append(singleRule).append("\n");
            }
            String partialScript = buf.toString();
            ZimbraLog.filter.debug("Applying partial script to existing messages: %s", partialScript);
            node = null;
            try {
                node = RuleManager.parse(partialScript);
            }
            catch (ParseException e) {
                throw ServiceException.FAILURE("Unable to parse Sieve script: " + partialScript, e);
            }
            Element msgEl = request.getOptionalElement("m");
            String query = this.getElementText(request, "query");
            if (msgEl != null && query != null) {
                String msg = String.format("Cannot specify both %s and %s elements.", "m", "query");
                throw ServiceException.INVALID_REQUEST(msg, null);
            }
            mbox = ApplyFilterRules.getRequestedMailbox(zsc);
            messageIds = new ArrayList<Integer>();
            affectedIds = new ArrayList<Integer>();
            if (msgEl != null) {
                String[] ids;
                for (String id : ids = msgEl.getAttribute("ids").split(",")) {
                    messageIds.add(Integer.valueOf(id));
                }
            } else {
                if (query == null) {
                    String msg = String.format("Must specify either the %s or %s element.", "m", "query");
                    throw ServiceException.INVALID_REQUEST(msg, null);
                }
                byte[] types = new byte[]{5};
                ZimbraQueryResults results = null;
                try {
                    try {
                        results = mbox.search(new OperationContext(mbox), query, types, SortBy.NONE, Integer.MAX_VALUE);
                        while (results.hasNext()) {
                            ZimbraHit hit = results.getNext();
                            messageIds.add(hit.getItemId());
                        }
                        Object var21_32 = null;
                        if (results == null) break block25;
                    }
                    catch (Exception e) {
                        String msg = String.format("Unable to run search for query: '%s'", query);
                        throw ServiceException.INVALID_REQUEST(msg, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_33 = null;
                    if (results != null) {
                        results.doneWithSearchResults();
                    }
                    throw throwable;
                }
                results.doneWithSearchResults();
            }
        }
        ZimbraLog.filter.info("Applying filter rules to %s existing messages.", messageIds.size());
        Iterator i$ = messageIds.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            Mailbox mailbox = mbox;
            synchronized (mailbox) {
                Message msg = null;
                try {
                    msg = mbox.getMessageById(null, id);
                }
                catch (MailServiceException.NoSuchItemException e) {
                    ZimbraLog.filter.info("Skipping message %d: %s.", id, e.toString());
                }
                if (msg != null && RuleManager.applyRulesToExistingMessage(mbox, id, node)) {
                    affectedIds.add(id);
                }
            }
        }
        Element response = zsc.createElement(MailConstants.APPLY_FILTER_RULES_RESPONSE);
        if (affectedIds.size() > 0) {
            response.addElement("m").addAttribute("ids", StringUtil.join(",", affectedIds));
        }
        return response;
    }

    private String getElementText(Element parent, String childName) {
        Element child = parent.getOptionalElement(childName);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }
}

