/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.mail.SendMsg;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMsg
extends MailDocumentHandler {
    private static Log mLog = LogFactory.getLog(AddMsg.class);
    private static Pattern sNumeric = Pattern.compile("\\d+");
    private static final String[] TARGET_FOLDER_PATH = new String[]{"m", "l"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        String folder = AddMsg.getXPath(request, TARGET_FOLDER_PATH);
        return folder != null && (folder.indexOf(58) > 0 || sNumeric.matcher(folder).matches()) ? TARGET_FOLDER_PATH : null;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Message msg;
        String[] splitTags;
        ZimbraSoapContext zsc = AddMsg.getZimbraSoapContext(context);
        Mailbox mbox = AddMsg.getRequestedMailbox(zsc);
        OperationContext octxt = AddMsg.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element msgElem = request.getElement("m");
        String flagsStr = msgElem.getAttribute("f", null);
        String tagsStr = msgElem.getAttribute("t", null);
        String folderStr = msgElem.getAttribute("l");
        boolean noICal = msgElem.getAttributeBool("noICal", false);
        long date = msgElem.getAttributeLong("d", System.currentTimeMillis());
        if (mLog.isDebugEnabled()) {
            StringBuffer toPrint = new StringBuffer("<AddMsg ");
            if (tagsStr != null) {
                toPrint.append(" tags=\"").append(tagsStr).append("\"");
            }
            if (folderStr != null) {
                toPrint.append(" folder=\"").append(folderStr).append("\"");
            }
            toPrint.append(">");
            mLog.debug(toPrint);
        }
        if (tagsStr != null && (splitTags = tagsStr.split("\\s*,\\s*")).length > 0) {
            for (int i = 0; i < splitTags.length; ++i) {
                try {
                    int tagId = Integer.parseInt(splitTags[i]);
                    if (mbox.getTagById(octxt, tagId) == null) {
                        throw ServiceException.INVALID_REQUEST("Unknown tag: \"" + tagId + "\"", null);
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        int folderId = -1;
        Folder folder = null;
        try {
            folderId = new ItemId(folderStr, zsc).getId();
        }
        catch (ServiceException e) {
            // empty catch block
        }
        if (folderId > 0) {
            folder = mbox.getFolderById(octxt, folderId);
        } else {
            folder = mbox.getFolderByPath(octxt, folderStr);
            folderId = folder.getId();
        }
        if (mLog.isDebugEnabled()) {
            mLog.debug("folder = " + folder.getName());
        }
        String attachment = msgElem.getAttribute("aid", null);
        ParseMimeMessage.MimeMessageData mimeData = new ParseMimeMessage.MimeMessageData();
        MimeMessage mm = attachment != null ? SendMsg.parseUploadedMessage(zsc, attachment, mimeData) : ParseMimeMessage.importMsgSoap(msgElem);
        try {
            ParsedMessage pm = new ParsedMessage(mm, date, mbox.attachmentsIndexingEnabled());
            msg = mbox.addMessage(octxt, pm, folderId, noICal, Flag.flagsToBitmask(flagsStr), tagsStr);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("Error While Delivering Message", ioe);
        }
        if (mimeData.uploads != null) {
            FileUploadServlet.deleteUploads(mimeData.uploads);
        }
        Element response = zsc.createElement(MailConstants.ADD_MSG_RESPONSE);
        if (msg != null) {
            ToXML.encodeMessageSummary(response, ifmt, octxt, msg, null, 4195127);
        }
        return response;
    }
}

