/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.mail.SetCalendarItem;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCalendarItemInvite
extends CalendarRequest {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Invite[] invs;
        int f;
        int folderId;
        ZimbraSoapContext zsc = AddCalendarItemInvite.getZimbraSoapContext(context);
        Account acct = AddCalendarItemInvite.getRequestedAccount(zsc);
        Mailbox mbox = AddCalendarItemInvite.getRequestedMailbox(zsc);
        OperationContext octxt = AddCalendarItemInvite.getOperationContext(zsc, context);
        AddInviteParser parser = new AddInviteParser();
        Mailbox.SetCalendarItemData scid = SetCalendarItem.getSetCalendarItemData(zsc, octxt, acct, mbox, request, parser);
        Invite inv = scid.mInv;
        CalendarItem calItem = mbox.getCalendarItemByUid(octxt, inv.getUid());
        int n = folderId = inv.isTodo() ? 15 : 10;
        if (calItem != null && (f = calItem.getFolderId()) != 3 && f != 4) {
            folderId = f;
        }
        if (!inv.hasOrganizer() && inv.hasOtherAttendees()) {
            if (scid.mPm == null) {
                ZimbraLog.calendar.info("Got malformed invite without organizer.  Clearing attendees to prevent inadvertent cancels.");
                inv.clearAttendees();
            } else {
                String fromEmail = scid.mPm.getSenderEmail(true);
                if (fromEmail != null) {
                    String intendedForAddress;
                    boolean dangerousSender = false;
                    try {
                        intendedForAddress = scid.mPm.getMimeMessage().getHeader("X-Zimbra-Calendar-Intended-For", null);
                    }
                    catch (MessagingException e) {
                        throw ServiceException.FAILURE("error parsing message", e);
                    }
                    if (intendedForAddress != null && intendedForAddress.length() > 0) {
                        if (intendedForAddress.equalsIgnoreCase(fromEmail)) {
                            ZimbraLog.calendar.info("Got malformed invite without organizer.  Clearing attendees to prevent inadvertent cancels.");
                            inv.clearAttendees();
                            dangerousSender = true;
                        }
                    } else if (AccountUtil.addressMatchesAccount(acct, fromEmail)) {
                        ZimbraLog.calendar.info("Got malformed invite without organizer.  Clearing attendees to prevent inadvertent cancels.");
                        inv.clearAttendees();
                        dangerousSender = true;
                    }
                    if (!dangerousSender) {
                        ZOrganizer org = new ZOrganizer(fromEmail, null);
                        String senderEmail = scid.mPm.getSenderEmail(false);
                        if (senderEmail != null && !senderEmail.equalsIgnoreCase(fromEmail)) {
                            org.setSentBy(senderEmail);
                        }
                        inv.setOrganizer(org);
                        ZimbraLog.calendar.info("Got malformed invite that lists attendees without specifying an organizer.  Defaulting organizer to: " + org.toString());
                    }
                }
            }
        }
        int[] ids = mbox.addInvite(octxt, inv, folderId, scid.mPm, false, false, true);
        Element response = this.getResponseElement(zsc);
        if (ids != null && ids.length >= 2 && (calItem = mbox.getCalendarItemById(octxt, ids[0])) != null && (invs = calItem.getInvites(ids[1])) != null && invs.length > 0) {
            response.addAttribute("calItemId", ids[0]);
            response.addAttribute("invId", ids[1]);
            response.addAttribute("compNum", invs[0].getComponentNum());
        }
        return response;
    }

    protected class AddInviteParser
    extends ParseMimeMessage.InviteParser {
        protected AddInviteParser() {
        }

        public ParseMimeMessage.InviteParserResult parseInviteElement(ZimbraSoapContext lc, OperationContext octxt, Account account, Element inviteElem) throws ServiceException {
            return CalendarUtils.parseInviteForAddInvite(account, AddCalendarItemInvite.this.getItemType(), inviteElem, null);
        }
    }
}

