/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.im.IMUtils;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMSubscribe
extends IMDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMSubscribe.getZimbraSoapContext(context);
        OperationContext octxt = IMSubscribe.getOperationContext(zsc, context);
        String op = request.getAttribute("op");
        boolean add = true;
        if (op.equalsIgnoreCase("remove")) {
            add = false;
        }
        String addrStr = request.getAttribute("addr");
        String resolvedAddr = IMUtils.resolveAddress(addrStr);
        IMAddr addr = new IMAddr(resolvedAddr);
        Element response = zsc.createElement(IMConstants.IM_SUBSCRIBE_RESPONSE);
        response.addAttribute("addr", addr.toString());
        String name = request.getAttribute("name", "");
        String groupStr = request.getAttribute("groups", null);
        String[] groups = groupStr != null ? groupStr.split(",") : new String[]{};
        IMPersona persona = super.getRequestedPersona(zsc);
        Object object = persona.getLock();
        synchronized (object) {
            if (add) {
                persona.addOutgoingSubscription(octxt, addr, name, groups);
            } else {
                persona.removeOutgoingSubscription(octxt, addr, name, groups);
            }
        }
        return response;
    }
}

