/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.im.PrivacyList;
import com.zimbra.cs.im.PrivacyListEntry;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMSetPrivacyList
extends IMDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMSetPrivacyList.getZimbraSoapContext(context);
        Element list = request.getElement("list");
        PrivacyList pl = new PrivacyList(list.getAttribute("name", null));
        Iterator<Element> iter = list.elementIterator("item");
        while (iter.hasNext()) {
            Element item = iter.next();
            String actionStr = item.getAttribute("action");
            PrivacyListEntry.Action action = PrivacyListEntry.Action.valueOf(actionStr);
            int order = (int)item.getAttributeLong("order");
            if (order <= 0) {
                throw ServiceException.INVALID_REQUEST("Order must be >= 0 in item " + item.toString(), null);
            }
            String addr = item.getAttribute("addr");
            PrivacyListEntry entry = new PrivacyListEntry(new IMAddr(addr), order, action, 15);
            try {
                pl.addEntry(entry);
            }
            catch (PrivacyList.DuplicateOrderException e) {
                throw ServiceException.INVALID_REQUEST("Order must be unique for every item within list.  Problem at entry: " + item, e);
            }
        }
        IMPersona persona = this.getRequestedPersona(zsc);
        Object object = persona.getLock();
        synchronized (object) {
            persona.setPrivacyList(pl);
        }
        return zsc.createElement(IMConstants.IM_SET_PRIVACY_LIST_RESPONSE);
    }
}

