/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMSetIdle
extends IMDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMSetIdle.getZimbraSoapContext(context);
        if (!zsc.hasSession()) {
            throw ServiceException.FAILURE("Must be called in the context of a session", null);
        }
        IMPersona persona = super.getRequestedPersona(zsc);
        boolean isIdle = request.getAttributeBool("isIdle");
        long idleTimeSecs = request.getAttributeLong("idleTime");
        long idleStartTime = System.currentTimeMillis() - 1000L * idleTimeSecs;
        if (idleStartTime < 0L) {
            idleStartTime = 0L;
        }
        persona.setIdleState(this.getSession(zsc), isIdle, idleStartTime);
        return zsc.createElement(IMConstants.IM_SET_IDLE_RESPONSE);
    }
}

