/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.html.HtmlEntityMapper;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMMessage;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.im.IMUtils;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.StringReader;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMSendMessage
extends IMDocumentHandler {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        Element bodyElt;
        ZimbraSoapContext zsc = IMSendMessage.getZimbraSoapContext(context);
        OperationContext octxt = IMSendMessage.getOperationContext(zsc, context);
        Element response = zsc.createElement(IMConstants.IM_SEND_MESSAGE_RESPONSE);
        Element msgElt = request.getElement("message");
        String threadId = msgElt.getAttribute("thread", null);
        String addr = IMUtils.resolveAddress(msgElt.getAttribute("addr"));
        String subject = null;
        IMMessage.TextPart bodyPart = null;
        Element subjElt = msgElt.getOptionalElement("subject");
        if (subjElt != null) {
            subject = subjElt.getText();
        }
        if ((bodyElt = msgElt.getOptionalElement("body")) != null) {
            try {
                Element xhtmlElt = bodyElt.getOptionalElement("html");
                Element plainElt = bodyElt.getOptionalElement("text");
                if (xhtmlElt != null || plainElt != null) {
                    if (plainElt == null) {
                        throw ServiceException.INVALID_REQUEST("IMSendMessage: plaintext <text> element is required even if <xhtml> is sent", null);
                    }
                    String plainText = plainElt.getText();
                    if (xhtmlElt != null) {
                        org.dom4j.Element parsed;
                        String xhtmlText = xhtmlElt.getText();
                        xhtmlText = HtmlEntityMapper.htmlEntitiesToNumeric(xhtmlText);
                        org.dom4j.Element xhtmlBody = parsed = Element.getSAXReader().read(new StringReader("<body xmlns=\"http://www.w3.org/1999/xhtml\">" + xhtmlText + "</body>")).getRootElement();
                        xhtmlBody.detach();
                        bodyPart = new IMMessage.TextPart(plainText, xhtmlBody);
                    } else {
                        bodyPart = new IMMessage.TextPart(plainText);
                    }
                } else {
                    org.dom4j.Element parsed;
                    String s = bodyElt.getText();
                    org.dom4j.Element xhtmlBody = parsed = DocumentHelper.parseText("<body xmlns=\"http://www.w3.org/1999/xhtml\">" + s + "</body>").getRootElement();
                    xhtmlBody.detach();
                    bodyPart = new IMMessage.TextPart(xhtmlBody);
                }
            }
            catch (DocumentException e) {
                bodyPart = new IMMessage.TextPart(bodyElt.getText());
            }
        }
        boolean isTyping = false;
        if (msgElt.getOptionalElement("typing") != null) {
            isTyping = true;
        }
        IMMessage msg = new IMMessage(subject == null ? null : new IMMessage.TextPart(subject), bodyPart, isTyping);
        IMPersona persona = super.getRequestedPersona(zsc);
        Object object = persona.getLock();
        synchronized (object) {
            persona.sendMessage(octxt, new IMAddr(addr), threadId, msg);
        }
        response.addAttribute("thread", threadId);
        return response;
    }
}

