/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.im.IMAddr;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.im.IMServiceException;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmpp.packet.IQ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMModifyChat
extends IMDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = IMModifyChat.getZimbraSoapContext(context);
        OperationContext octxt = IMModifyChat.getOperationContext(zsc, context);
        Element response = zsc.createElement(IMConstants.IM_MODIFY_CHAT_RESPONSE);
        String threadId = request.getAttribute("thread");
        response.addAttribute("thread", threadId);
        IMPersona persona = super.getRequestedPersona(zsc);
        IMChat chat = null;
        if (persona != null) {
            chat = persona.getChat(threadId);
        }
        if (chat == null) {
            response.addAttribute("error", "not_found");
        } else {
            String opStr = request.getAttribute("op");
            Op op = Op.valueOf(opStr.toUpperCase());
            switch (op) {
                case CLOSE: {
                    Object object = persona.getLock();
                    synchronized (object) {
                        persona.closeChat(octxt, chat);
                        break;
                    }
                }
                case ADDUSER: {
                    Object object = persona.getLock();
                    synchronized (object) {
                        String newUser = request.getAttribute("addr");
                        String inviteMessage = request.getText();
                        if (inviteMessage == null || inviteMessage.length() == 0) {
                            inviteMessage = "Please join my chat";
                        }
                        persona.addUserToChat(octxt, chat, new IMAddr(newUser), inviteMessage);
                        break;
                    }
                }
                case CONFIGURE: {
                    this.handleConfigure(persona, chat, request, response);
                }
            }
        }
        return response;
    }

    private void handleConfigure(IMPersona persona, IMChat chat, Element request, Element response) throws ServiceException {
        if (!chat.isMUC()) {
            throw IMServiceException.NOT_A_MUC_CHAT(chat.getThreadId());
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        Iterator<Element> iter = request.elementIterator("var");
        while (iter.hasNext()) {
            Element var = iter.next();
            String name = var.getAttribute("name");
            boolean isMulti = var.getAttributeBool("multi", false);
            if (!isMulti) {
                String s = var.getText().trim();
                if (s.length() <= 0) continue;
                data.put(name, s);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            Iterator<Element> valueIter = var.elementIterator("value");
            while (valueIter.hasNext()) {
                Element valueElt = valueIter.next();
                String s = valueElt.getText().trim();
                if (s.length() <= 0) continue;
                values.add(s);
            }
            data.put(name, values);
        }
        IQ result = persona.configureChat(chat, data);
        if (result == null) {
            throw IMServiceException.NO_RESPONSE_FROM_REMOTE("Attempting to configure chat " + chat.toString(), chat.getThreadId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Op {
        CLOSE,
        ADDUSER,
        CONFIGURE;

    }
}

