/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMJoinConferenceRoom
extends IMDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMJoinConferenceRoom.getZimbraSoapContext(context);
        Element response = zsc.createElement(IMConstants.IM_JOIN_CONFERENCE_ROOM_RESPONSE);
        String threadId = request.getAttribute("thread", null);
        String addr = request.getAttribute("addr");
        String nickname = request.getAttribute("nick", null);
        String password = request.getAttribute("password", null);
        IMPersona persona = super.getRequestedPersona(zsc);
        Pair<String, List<IMChat.MucStatusCode>> results = persona.joinConferenceRoom(addr, threadId, nickname, password);
        StringBuilder errors = new StringBuilder();
        StringBuilder status = new StringBuilder();
        for (IMChat.MucStatusCode code : results.getSecond()) {
            if (code.isError()) {
                if (errors.length() > 0) {
                    errors.append(",");
                }
                errors.append(code.name());
                continue;
            }
            if (status.length() > 0) {
                status.append(",");
            }
            status.append(code.name());
        }
        response.addAttribute("thread", results.getFirst());
        if (status.length() > 0) {
            response.addAttribute("status", status.toString());
        }
        if (errors.length() > 0) {
            response.addAttribute("error", errors.toString());
        }
        return response;
    }
}

