/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMGetRoster
extends IMDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMGetRoster.getZimbraSoapContext(context);
        Element response = zsc.createElement(IMConstants.IM_GET_ROSTER_RESPONSE);
        IMPersona persona = super.getRequestedPersona(zsc);
        Object object = persona.getLock();
        synchronized (object) {
            Element pres = response.addUniqueElement("presence");
            persona.getEffectivePresence().toXml(pres);
            Element chats = response.addUniqueElement("chats");
            for (IMChat chat : persona.chats()) {
                Element e = chats.addElement("chats");
                e.addAttribute("thread", chat.getThreadId());
                Element participantsElt = e.addElement("pcps");
                for (IMChat.Participant part : chat.participants()) {
                    Element pe = participantsElt.addElement("p");
                    pe.addAttribute("addr", part.getAddress().getAddr());
                }
            }
            Session s = this.getSession(zsc);
            if (s != null) {
                persona.refreshRoster(s);
                persona.getDefaultPrivacyList();
                persona.refreshChats(s);
            }
        }
        return response;
    }
}

