/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.cs.im.IMConferenceRoom;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.im.IMServiceException;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMGetChatConfiguration
extends IMDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMGetChatConfiguration.getZimbraSoapContext(context);
        Element response = zsc.createElement(IMConstants.IM_GET_CHAT_CONFIGURATION_RESPONSE);
        String threadId = request.getAttribute("thread", null);
        String addr = request.getAttribute("addr", null);
        if (threadId == null && addr == null) {
            throw ServiceException.INVALID_REQUEST("Missing required argument -- one of (thread, addr) must be specified", null);
        }
        boolean requestOwnerConfig = request.getAttributeBool("requestOwnerConfig", false);
        response.addAttribute("thread", threadId);
        IMPersona persona = super.getRequestedPersona(zsc);
        try {
            IMConferenceRoom room = persona.getConferenceRoom(threadId, addr, requestOwnerConfig);
            if (room != null) {
                response = room.toXML(response);
            }
        }
        catch (IMServiceException e) {
            if (e.getCode().equals("im.NOT_A_CONFERENCE_ROOM")) {
                response.addAttribute("error", "not_a_conference_room");
            }
            if (e.getCode().equals("im.NO_RESPONSE")) {
                response.addAttribute("error", "no_response_from_remote");
            }
            if (e.getCode().equals("im.NOT_ALLOWED")) {
                response.addAttribute("error", "not_allowed");
            }
            throw e;
        }
        catch (MailServiceException e) {
            if (e.getCode().equals("mail.NO_SUCH_CHAT")) {
                response.addAttribute("error", "not_found");
            }
            throw e;
        }
        return response;
    }
}

