/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.im.IMChat;
import com.zimbra.cs.im.IMMessage;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMGetChat
extends IMDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = IMGetChat.getZimbraSoapContext(context);
        Element response = zsc.createElement(IMConstants.IM_GET_CHAT_RESPONSE);
        String threadId = request.getAttribute("thread");
        IMPersona persona = super.getRequestedPersona(zsc);
        Object object = persona.getLock();
        synchronized (object) {
            IMChat chat = persona.getChat(threadId);
            if (chat != null) {
                response = IMGetChat.chatToXml(chat, response);
            } else {
                response.addAttribute("error", "not_found");
            }
        }
        response.addAttribute("thread", threadId);
        return response;
    }

    public static Element chatToXml(IMChat chat, Element parent) {
        Element ce = parent.addElement("chat");
        ce.addAttribute("thread", chat.getThreadId());
        Element e = ce.addElement("pcps");
        for (IMChat.Participant part : chat.participants()) {
            part.toXML(e);
        }
        Element messages = ce.addElement("messages");
        int curOffset = 0;
        for (IMMessage msg : chat.messages()) {
            IMMessage.TextPart body;
            Element me = messages.addElement("message");
            me.addAttribute("seq", curOffset + chat.getFirstSeqNo());
            me.addAttribute("ts", msg.getTimestamp());
            me.addAttribute("from", msg.getFrom().getAddr());
            IMMessage.TextPart subj = msg.getSubject(IMMessage.Lang.DEFAULT);
            if (subj != null) {
                Element se = me.addElement("subject");
                se.setText(subj.getPlainText());
            }
            if ((body = msg.getBody(IMMessage.Lang.DEFAULT)) != null) {
                String s = body.toString();
                me.addElement("body").setText(s);
            }
            ++curOffset;
        }
        return parent;
    }
}

