/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.IMConstants;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.im.GatewayRegistrationStatus;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.service.im.IMDocumentHandler;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMGatewayList
extends IMDocumentHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMGatewayList.getZimbraSoapContext(context);
        Element response = zsc.createElement(IMConstants.IM_GATEWAY_LIST_RESPONSE);
        IMPersona persona = this.getRequestedPersona(zsc);
        Object object = persona.getLock();
        synchronized (object) {
            Session s = IMGatewayList.getReferencedSession(zsc);
            if (s != null) {
                s.registerWithIM(persona);
            }
            List<Pair<String, GatewayRegistrationStatus>> types = persona.getAvailableGateways();
            String domain = persona.getDomain();
            for (Pair<String, GatewayRegistrationStatus> p : types) {
                Element typeElt = response.addElement("service");
                typeElt.addAttribute("type", p.getFirst());
                typeElt.addAttribute("domain", p.getFirst() + "." + domain);
                if (p.getSecond() == null) continue;
                Element rElt = typeElt.addElement("registration");
                rElt.addAttribute("name", p.getSecond().username);
                rElt.addAttribute("state", p.getSecond().state.toLowerCase());
                if (p.getSecond().nextConnectAttemptTime <= 0L) continue;
                rElt.addAttribute("timeUntilNextConnect", p.getSecond().nextConnectAttemptTime - System.currentTimeMillis());
            }
        }
        return response;
    }
}

