/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.im;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.operation.BlockingOperation;
import com.zimbra.cs.operation.Requester;
import com.zimbra.cs.operation.Scheduler;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IMDocumentHandler
extends DocumentHandler {
    @Override
    public Object preHandle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = IMDocumentHandler.getZimbraSoapContext(context);
        Session session = this.getSession(zsc);
        OperationContext octxt = IMDocumentHandler.getOperationContext(zsc, context);
        Mailbox mbox = IMDocumentHandler.getRequestedMailbox(zsc);
        return BlockingOperation.schedule(request.getName(), session, octxt, mbox, Requester.SOAP, this.getSchedulerPriority(), 1);
    }

    @Override
    public void postHandle(Object userObj) {
        ((BlockingOperation)userObj).finish();
    }

    protected Scheduler.Priority getSchedulerPriority() {
        return Scheduler.Priority.INTERACTIVE_HIGH;
    }

    protected IMPersona getRequestedPersona(ZimbraSoapContext zsc) throws ServiceException {
        return IMDocumentHandler.getRequestedMailbox(zsc).getPersona();
    }
}

