/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.zip.ZipEntry;
import com.zimbra.common.util.zip.ZipOutputStream;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.ArchiveFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;

public class ZipFormatter
extends ArchiveFormatter {
    public String[] getDefaultMimeTypes() {
        return new String[]{"application/zip", "application/x-zip-compressed"};
    }

    public String getType() {
        return "zip";
    }

    protected boolean getDefaultMeta() {
        return false;
    }

    protected ArchiveFormatter.ArchiveInputStream getInputStream(UserServlet.Context context, String charset) throws IOException, ServiceException, UserServletException {
        return new ZipArchiveInputStream(context.getRequestInputStream(-1L), charset);
    }

    protected ArchiveFormatter.ArchiveOutputStream getOutputStream(UserServlet.Context context, String charset) throws IOException {
        ServletOutputStream os = context.resp.getOutputStream();
        String zlv = context.params.get("zlv");
        int lvl = -1;
        if (zlv != null && zlv.length() > 0) {
            try {
                lvl = Integer.parseInt(zlv);
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        return new ZipArchiveOutputStream((OutputStream)os, charset, lvl);
    }

    public class ZipArchiveOutputStream
    implements ArchiveFormatter.ArchiveOutputStream {
        private ZipOutputStream os;

        public ZipArchiveOutputStream(OutputStream os, String cset, int lvl) throws IOException {
            this.os = new ZipOutputStream(os);
            this.os.setEncoding(cset);
            if (lvl >= 0 && lvl <= 9) {
                this.os.setLevel(lvl);
            }
        }

        public void close() throws IOException {
            this.os.close();
        }

        public void closeEntry() throws IOException {
            this.os.closeEntry();
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        public int getRecordSize() {
            return 2048;
        }

        public ArchiveFormatter.ArchiveOutputEntry newOutputEntry(String path, String name, int type, long date) {
            return new ZipArchiveOutputEntry(path, name, type, date);
        }

        public void putNextEntry(ArchiveFormatter.ArchiveOutputEntry entry) throws IOException {
            this.os.putNextEntry(((ZipArchiveOutputEntry)entry).entry);
        }

        public void write(byte[] buf) throws IOException {
            this.os.write(buf);
        }

        public void write(byte[] buf, int offset, int len) throws IOException {
            this.os.write(buf, offset, len);
        }

        public class ZipArchiveOutputEntry
        implements ArchiveFormatter.ArchiveOutputEntry {
            private ZipEntry entry;

            public ZipArchiveOutputEntry(String path, String name, int type, long date) {
                this.entry = new ZipEntry(path);
                this.entry.setComment(name);
                this.entry.setTime(date);
                this.entry.setUnixMode(432);
            }

            public void setUnread() {
                this.entry.setUnixMode(416);
                this.entry.setComment(this.entry.getComment() + "-unread");
            }

            public void setSize(long size) {
                this.entry.setSize(size);
            }
        }
    }

    public class ZipArchiveInputStream
    implements ArchiveFormatter.ArchiveInputStream {
        private ZipInputStream is;

        public ZipArchiveInputStream(InputStream is, String cset) {
            this.is = new ZipInputStream(is);
        }

        public void close() throws IOException {
            this.is.close();
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public ArchiveFormatter.ArchiveInputEntry getNextEntry() throws IOException {
            ZipArchiveInputEntry zaie = new ZipArchiveInputEntry(this.is);
            return zaie.entry == null ? null : zaie;
        }

        public int read(byte[] buf, int offset, int len) throws IOException {
            return this.is.read(buf, offset, len);
        }

        public class ZipArchiveInputEntry
        implements ArchiveFormatter.ArchiveInputEntry {
            private java.util.zip.ZipEntry entry;

            public ZipArchiveInputEntry(ZipInputStream is) throws IOException {
                this.entry = is.getNextEntry();
            }

            public long getModTime() {
                return this.entry.getTime();
            }

            public String getName() {
                return this.entry.getName();
            }

            public long getSize() {
                return this.entry.getSize();
            }

            public int getType() {
                return 0;
            }

            public boolean isUnread() {
                return this.entry.getComment() != null && this.entry.getComment().endsWith("-unread");
            }
        }
    }
}

