/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemIdFormatter;
import java.io.IOException;
import java.util.Iterator;

public class XmlFormatter
extends Formatter {
    public String getType() {
        return "xml";
    }

    public boolean canBeBlocked() {
        return false;
    }

    public String getDefaultSearchTypes() {
        return "appointment,contact,document,briefcase,message,note,task,wiki";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatCallback(UserServlet.Context context) throws ServiceException, IOException {
        Element elt = this.getFactory().createElement("items");
        ItemIdFormatter ifmt = new ItemIdFormatter(context.authAccount, context.targetMailbox, false);
        Iterator<? extends MailItem> iterator = null;
        try {
            iterator = this.getMailItems(context, this.getDefaultStartTime(), this.getDefaultEndTime(), Integer.MAX_VALUE);
            while (iterator.hasNext()) {
                ToXML.encodeItem(elt, ifmt, context.opContext, iterator.next(), -4194305);
            }
            context.resp.getOutputStream().write(elt.toUTF8());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (iterator instanceof Formatter.QueryResultIterator) {
                ((Formatter.QueryResultIterator)iterator).finished();
            }
            throw throwable;
        }
        if (iterator instanceof Formatter.QueryResultIterator) {
            ((Formatter.QueryResultIterator)iterator).finished();
        }
    }

    Element.ElementFactory getFactory() {
        return Element.XMLElement.mFactory;
    }
}

