/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.html.HtmlDefang;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.mime.ParsedDocument;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.wiki.PageCache;
import com.zimbra.cs.wiki.WikiPage;
import com.zimbra.cs.wiki.WikiTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class WikiFormatter
extends Formatter {
    private static PageCache sCache = new PageCache();
    private static final String TOC = "_Index";
    private static final String CHROME = "_Template";
    private static final String VERSION_CHROME = "_VersionTemplate";
    private static final String VERSION = "_VersionIndex";

    public String getType() {
        return "wiki";
    }

    public boolean canBeBlocked() {
        return true;
    }

    public static void expireCacheItem(MailItem item) {
        try {
            String key = sCache.generateKey(item.getAccount(), item);
            sCache.removePage(key);
        }
        catch (ServiceException e) {
            ZimbraLog.wiki.info((Object)"unable to expire item from cache", e);
        }
    }

    public static void expireCache() {
        sCache = new PageCache();
    }

    private void handleWiki(UserServlet.Context context, WikiItem wiki) throws IOException, ServiceException {
        WikiPage.WikiContext ctxt = this.createWikiContext(context);
        String template = null;
        String v = context.params.get("ver");
        if (v == null) {
            String key = sCache.generateKey(context.opContext.getAuthenticatedUser(), wiki);
            template = sCache.getPage(key);
            if (template == null) {
                WikiTemplate wt = this.getTemplate(context, wiki);
                template = wt.getComposedPage(ctxt, wiki, CHROME);
            }
        } else {
            WikiTemplate wt = this.getTemplate(context, wiki);
            template = wt.getComposedPage(ctxt, wiki, VERSION_CHROME);
        }
        String url = UserServlet.getRestUrl(wiki);
        WikiFormatter.printWikiPage(context, template, wiki.getName(), url, this.neuterHtmlTags(wiki.getAccount()));
    }

    private void handleWikiHistory(UserServlet.Context context, WikiItem wiki) throws IOException, ServiceException {
        WikiPage.WikiContext ctxt = this.createWikiContext(context);
        String template = null;
        WikiPage chromePage = WikiPage.findTemplate(ctxt, wiki.getMailbox().getAccountId(), VERSION);
        WikiTemplate wt = chromePage.getTemplate(ctxt);
        template = wt.getComposedPage(ctxt, wiki, VERSION_CHROME);
        String url = UserServlet.getRestUrl(wiki);
        WikiFormatter.printWikiPage(context, template, wiki.getName(), url, this.neuterHtmlTags(wiki.getAccount()));
    }

    private WikiTemplate getTemplate(UserServlet.Context context, WikiItem item) throws ServiceException {
        return this.getTemplate(context, item.getMailbox().getAccountId(), item.getFolderId(), item.getWikiWord());
    }

    private WikiTemplate getTemplate(UserServlet.Context context, String accountId, int folderId, String name) throws ServiceException {
        int ver = -1;
        String v = context.params.get("ver");
        if (v != null) {
            ver = Integer.parseInt(v);
        }
        WikiPage.WikiContext wctxt = this.createWikiContext(context);
        MailItem item = context.targetMailbox.getItemByPath(context.opContext, name, folderId);
        int id = item.getId();
        if (ver != -1) {
            item = context.targetMailbox.getItemRevision(context.opContext, id, (byte)8, ver);
        }
        WikiPage page = WikiPage.create((Document)item);
        return page.getTemplate(wctxt);
    }

    private WikiTemplate getDefaultTOC() {
        return WikiTemplate.getDefaultTOC();
    }

    private WikiPage.WikiContext createWikiContext(UserServlet.Context context) {
        return new WikiPage.WikiContext(context.opContext, context.cookieAuthHappened ? context.authToken : null, context.getView(), context.locale);
    }

    private void handleWikiFolder(UserServlet.Context context, Folder folder) throws IOException, ServiceException {
        WikiPage.WikiContext ctxt = this.createWikiContext(context);
        String key = sCache.generateKey(context.opContext.getAuthenticatedUser(), folder);
        String template = sCache.getPage(key);
        if (template == null) {
            WikiPage chromePage = WikiPage.findTemplate(ctxt, folder.getAccount().getId(), TOC);
            WikiTemplate wt = null;
            wt = chromePage == null ? this.getDefaultTOC() : chromePage.getTemplate(ctxt);
            template = wt.getComposedPage(ctxt, folder, CHROME);
        }
        String url = UserServlet.getRestUrl(folder);
        WikiFormatter.printWikiPage(context, template, folder.getName(), url, this.neuterHtmlTags(folder.getAccount()));
    }

    private boolean neuterHtmlTags(Account acct) throws ServiceException {
        if (acct != null) {
            return acct.getBooleanAttr("zimbraNotebookSanitizeHtml", true);
        }
        return true;
    }

    private static void printWikiPage(UserServlet.Context context, String s, String title, String baseURL, boolean neuter) throws IOException {
        String disp = context.req.getParameter("disp");
        disp = disp == null || disp.toLowerCase().startsWith("i") ? "inline" : "attachment";
        context.resp.setContentType("text/html; charset=utf-8");
        if (disp.equals("attachment")) {
            String cd = disp + "; filename=" + HttpUtil.encodeFilename(context.req, title);
            context.resp.addHeader("Content-Disposition", cd);
        }
        PrintWriter out = context.resp.getWriter();
        out.println("<HTML>");
        out.println("<HEAD>");
        out.println("<TITLE>");
        out.println(title);
        out.println("</TITLE>");
        out.println("<base href='" + baseURL + "'/>");
        String defaultFontFamily = context.targetAccount.getAttr("zimbraPrefHtmlEditorDefaultFontFamily");
        String defaultFontColor = context.targetAccount.getAttr("zimbraPrefHtmlEditorDefaultFontColor");
        String defaultFontSize = context.targetAccount.getAttr("zimbraPrefHtmlEditorDefaultFontSize");
        out.print("<LINK rel='stylesheet' type='text/css' href='/zimbra/css/wiki.css'>");
        if (defaultFontFamily != null) {
            out.print("<style>");
            out.print("body, table{ ");
            out.print("font-family:" + defaultFontFamily + ";");
            out.print("color:" + defaultFontColor + ";");
            out.print("font-size:" + defaultFontSize + ";");
            out.print("}");
            out.print("</style>");
        }
        out.println("</HEAD>");
        out.println("<BODY style='margin:0px'>");
        if (neuter && !disp.equals("attachment")) {
            out.println(HtmlDefang.defang(s, false));
        } else {
            out.println(s);
        }
        out.println("</BODY>");
        out.println("</HTML>");
    }

    public void formatCallback(UserServlet.Context context) throws UserServletException, ServiceException, IOException {
        String view = context.params.get("view");
        if (view != null && view.compareTo("history") == 0 && context.target instanceof WikiItem) {
            this.handleWikiHistory(context, (WikiItem)context.target);
        } else if (context.target instanceof WikiItem) {
            this.handleWiki(context, (WikiItem)context.target);
        } else if (context.target instanceof Folder) {
            this.handleWikiFolder(context, (Folder)context.target);
        } else {
            throw UserServletException.notImplemented("can only handle Wiki messages and Documents");
        }
    }

    public boolean supportsSave() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCallback(UserServlet.Context context, String contentType, Folder folder, String filename) throws UserServletException, ServiceException, IOException {
        Document item;
        block7: {
            if (filename == null) {
                throw new UserServletException(400, "filename cannot be empty");
            }
            String creator = context.authAccount == null ? null : context.authAccount.getName();
            InputStream is = context.getRequestInputStream();
            Mailbox mbox = folder.getMailbox();
            ParsedDocument pd = new ParsedDocument(is, filename, "text/html; charset=utf-8", System.currentTimeMillis(), creator);
            item = null;
            try {
                try {
                    MailItem orig = mbox.getItemByPath(context.opContext, filename, folder.getId());
                    if (!(orig instanceof WikiItem)) {
                        throw new UserServletException(400, "cannot overwrite existing object at that path");
                    }
                    item = mbox.addDocumentRevision(context.opContext, orig.getId(), pd);
                }
                catch (MailServiceException.NoSuchItemException nsie) {
                    item = mbox.createDocument(context.opContext, folder.getId(), pd, (byte)14);
                    Object var12_13 = null;
                    is.close();
                    break block7;
                }
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                is.close();
                throw throwable;
            }
            is.close();
        }
        if (item != null) {
            context.resp.addHeader("X-Zimbra-ItemId", item.getId() + "");
            context.resp.addHeader("X-Zimbra-Version", item.getVersion() + "");
            context.resp.addHeader("X-Zimbra-Modified", item.getChangeDate() + "");
            context.resp.addHeader("X-Zimbra-Change", item.getModifiedSequence() + "");
            context.resp.addHeader("X-Zimbra-Revision", item.getSavedSequence() + "");
        }
        WikiFormatter.expireCacheItem(folder);
    }
}

