/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.service.formatter.VCard;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class VcfFormatter
extends Formatter {
    public String getType() {
        return "vcf";
    }

    public String[] getDefaultMimeTypes() {
        return new String[]{"text/x-vcard", "application/vcard"};
    }

    public String getDefaultSearchTypes() {
        return "contact";
    }

    public boolean canBeBlocked() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException {
        Iterator<? extends MailItem> iterator = null;
        try {
            iterator = this.getMailItems(context, this.getDefaultStartTime(), this.getDefaultEndTime(), Integer.MAX_VALUE);
            String filename = context.target instanceof Contact ? ((Contact)context.target).getFileAsString() : "contacts";
            String cd = "attachment; filename=" + HttpUtil.encodeFilename(context.req, filename + ".vcf");
            context.resp.addHeader("Content-Disposition", cd);
            context.resp.setContentType("text/x-vcard");
            context.resp.setCharacterEncoding("utf-8");
            int count = 0;
            while (iterator.hasNext()) {
                MailItem item = iterator.next();
                if (!(item instanceof Contact)) continue;
                VCard vcf = VCard.formatContact((Contact)item);
                context.resp.getOutputStream().write(vcf.formatted.getBytes("utf-8"));
                ++count;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (iterator instanceof Formatter.QueryResultIterator) {
                ((Formatter.QueryResultIterator)iterator).finished();
            }
            throw throwable;
        }
        if (iterator instanceof Formatter.QueryResultIterator) {
            ((Formatter.QueryResultIterator)iterator).finished();
        }
    }

    public boolean supportsSave() {
        return true;
    }

    public void saveCallback(UserServlet.Context context, String contentType, Folder folder, String filename) throws ServiceException, IOException, UserServletException {
        byte[] body = context.getPostBody();
        List<VCard> cards = VCard.parseVCard(new String(body, "utf-8"));
        if (cards == null || cards.size() == 0 || cards.size() == 1 && cards.get((int)0).fields.isEmpty()) {
            throw new UserServletException(400, "no contact fields found in vcard");
        }
        for (VCard vcf : cards) {
            if (vcf.fields.isEmpty()) continue;
            folder.getMailbox().createContact(context.opContext, vcf.asParsedContact(), folder.getId(), null);
        }
    }
}

