/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.util.Zimbra;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCard {
    public String uid;
    public String fn;
    public String formatted;
    public Map<String, String> fields;
    public List<Contact.Attachment> attachments;
    private static final Set<String> PROPERTY_NAMES = new HashSet<String>(Arrays.asList("BEGIN", "FN", "N", "NICKNAME", "PHOTO", "BDAY", "ADR", "TEL", "EMAIL", "URL", "ORG", "TITLE", "NOTE", "AGENT", "END", "UID"));
    static final Map<String, String> PARAM_ABBREVIATIONS = new HashMap<String, String>();
    private static final String[] NAME_FIELDS;
    private static final String[] ADR_HOME_FIELDS;
    private static final String[] ADR_WORK_FIELDS;
    private static final String[] ADR_OTHER_FIELDS;
    private static final String[] ORG_FIELDS;
    private static final String[] EMAIL_FIELDS;

    private VCard(String xfn, String xformatted, Map<String, String> xfields, List<Contact.Attachment> xattachments, String xuid) {
        this.fn = xfn;
        this.formatted = xformatted;
        this.fields = xfields;
        this.attachments = xattachments;
        this.uid = xuid;
    }

    public ParsedContact asParsedContact() throws ServiceException {
        return new ParsedContact(this.fields, this.attachments);
    }

    /*
     * Unable to fully structure code
     */
    public static List<VCard> parseVCard(String vcard) throws ServiceException {
        cards = new ArrayList<VCard>();
        fields = new HashMap<String, String>();
        xprops = new HashMap<String, String>();
        attachments = new ArrayList<Contact.Attachment>();
        vcprop = new VCardProperty();
        depth = 0;
        cardstart = 0;
        emails = 0;
        uid = null;
        start = 0;
        pos = 0;
        lines = 0;
        limit = vcard.length();
        while (pos < limit) {
            block49: {
                block50: {
                    line = "";
                    name = null;
                    value = null;
                    linestart = pos;
                    folded = true;
                    do {
                        start = pos;
                        while (pos < limit && vcard.charAt(pos) != '\r' && vcard.charAt(pos) != '\n') {
                            ++pos;
                        }
                        line = line + vcard.substring(start, pos);
                        if (pos < limit) {
                            if (pos < limit && vcard.charAt(pos) == '\r') {
                                ++pos;
                            }
                            if (pos < limit && vcard.charAt(pos) == '\n') {
                                ++pos;
                            }
                        }
                        if (pos < limit && (vcard.charAt(pos) == ' ' || vcard.charAt(pos) == '\t')) {
                            ++pos;
                            continue;
                        }
                        name = vcprop.parse(line);
                        if (vcprop.getEncoding() == Encoding.Q && line.endsWith("=")) continue;
                        folded = false;
                    } while (folded);
                    if (vcprop.isEmpty()) break block49;
                    if (name.equals("")) {
                        throw ServiceException.PARSE_ERROR("missing property name in line " + line, null);
                    }
                    if (!name.startsWith("X-")) break block50;
                    xprops.put(name, VCard.vcfDecode(vcprop.getValue()));
                    ** GOTO lbl-1000
                }
                if (VCard.PROPERTY_NAMES.contains(name)) {
                    if (name.equals("BEGIN")) {
                        if (++depth == 1) {
                            fields = new HashMap<K, V>();
                            xprops = new HashMap<K, V>();
                            attachments = new ArrayList<E>();
                            cardstart = linestart;
                            emails = 0;
                            uid = null;
                        }
                    } else if (name.equals("END")) {
                        if (depth > 0 && depth-- == 1) {
                            if (!xprops.isEmpty()) {
                                fields.put("vcardXProps", Contact.encodeXProps(xprops));
                            }
                            if (!fields.isEmpty()) {
                                Contact.normalizeFileAs(fields);
                                cards.add(new VCard((String)fields.get("fullName"), vcard.substring(cardstart, pos), fields, attachments, uid));
                            }
                        }
                    } else if (depth > 0) {
                        ** if (!name.equals((Object)"AGENT")) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            if (vcprop.getValue().trim().toUpperCase().matches((String)"BEGIN\\s*:\\s*VCARD")) {
                                ++depth;
                            } else {
                                ** GOTO lbl70
                            }
lbl70:
                            // 3 sources

                            ** GOTO lbl127
                        }
                    }
                }
                break block49;
lbl-1000:
                // 2 sources

                {
                    if (vcprop.getEncoding() == Encoding.B && !vcprop.containsParam("VALUE=URI") && name.equals("PHOTO")) {
                        suffix = vcprop.getParamValue("TYPE");
                        ctype = null;
                        if (suffix != null && !suffix.equals("")) {
                            ctype = "image/" + suffix.toLowerCase();
                            suffix = '.' + suffix;
                        }
                        attachments.add(new Contact.Attachment(vcprop.getDecoded(), ctype, "image", "image" + suffix));
                    } else {
                        value = vcprop.getValue();
                        if (name.equals("FN")) {
                            fields.put("fullName", VCard.vcfDecode(value));
                        } else if (name.equals("N")) {
                            VCard.decodeStructured(value, VCard.NAME_FIELDS, fields);
                        } else if (name.equals("NICKNAME")) {
                            fields.put("nickname", VCard.vcfDecode(value));
                        } else if (name.equals("PHOTO")) {
                            fields.put("image", VCard.vcfDecode(value));
                        } else if (name.equals("BDAY")) {
                            fields.put("birthday", VCard.vcfDecode(value));
                        } else if (name.equals("ADR")) {
                            VCard.decodeAddress(value, vcprop, fields);
                        } else if (name.equals("TEL")) {
                            VCard.decodeTelephone(value, vcprop, fields);
                        } else if (name.equals("URL")) {
                            VCard.decodeURL(value, vcprop, fields);
                        } else if (name.equals("ORG")) {
                            VCard.decodeStructured(value, VCard.ORG_FIELDS, fields);
                        } else if (name.equals("TITLE")) {
                            fields.put("jobTitle", VCard.vcfDecode(value));
                        } else if (name.equals("NOTE")) {
                            fields.put("notes", VCard.vcfDecode(value));
                        } else if (name.equals("EMAIL") && emails < VCard.EMAIL_FIELDS.length) {
                            fields.put(VCard.EMAIL_FIELDS[emails++], VCard.vcfDecode(value));
                        } else if (name.equals("UID")) {
                            uid = value;
                        }
                    }
                }
            }
            ++lines;
        }
        return cards;
    }

    private static void decodeTelephone(String value, VCardProperty vcprop, Map<String, String> fields) {
        value = VCard.vcfDecode(value);
        if (vcprop.containsParam("TYPE=CAR")) {
            fields.put("carPhone", value);
            return;
        }
        if (vcprop.containsParam("TYPE=CELL")) {
            fields.put("mobilePhone", value);
            return;
        }
        if (vcprop.containsParam("TYPE=PAGER")) {
            fields.put("pager", value);
            return;
        }
        boolean home = vcprop.containsParam("TYPE=HOME");
        boolean work = vcprop.containsParam("TYPE=WORK");
        boolean fax = vcprop.containsParam("TYPE=FAX");
        boolean voice = vcprop.containsParam("TYPE=VOICE");
        if (home) {
            if (fax) {
                fields.put("homeFax", value);
            }
            if (voice || !fax) {
                if (!fields.containsKey("homePhone")) {
                    fields.put("homePhone", value);
                } else if (!fields.containsKey("homePhone2")) {
                    fields.put("homePhone2", value);
                }
            }
        }
        if (work) {
            if (fax) {
                fields.put("workFax", value);
            }
            if (voice || !fax) {
                if (!fields.containsKey("workPhone")) {
                    fields.put("workPhone", value);
                } else if (!fields.containsKey("workPhone2")) {
                    fields.put("workPhone2", value);
                }
            }
        }
        if (!home && !work) {
            if (fax) {
                fields.put("otherFax", value);
            }
            if (!(!voice && fax || fields.containsKey("otherPhone"))) {
                fields.put("otherPhone", value);
            }
        }
    }

    private static void decodeAddress(String value, VCardProperty vcprop, Map<String, String> fields) {
        boolean home = vcprop.containsParam("TYPE=HOME");
        boolean work = vcprop.containsParam("TYPE=WORK");
        if (home) {
            VCard.decodeStructured(value, ADR_HOME_FIELDS, fields);
        }
        if (work) {
            VCard.decodeStructured(value, ADR_WORK_FIELDS, fields);
        }
        if (!home && !work) {
            VCard.decodeStructured(value, ADR_OTHER_FIELDS, fields);
        }
    }

    private static void decodeURL(String value, VCardProperty vcprop, Map<String, String> fields) {
        boolean home = vcprop.containsParam("TYPE=HOME");
        boolean work = vcprop.containsParam("TYPE=WORK");
        if (home) {
            fields.put("homeURL", VCard.vcfDecode(value));
        }
        if (work) {
            fields.put("workURL", VCard.vcfDecode(value));
        }
        if (!home && !work) {
            fields.put("otherURL", VCard.vcfDecode(value));
        }
    }

    private static void decodeStructured(String value, String[] keys, Map<String, String> fields) {
        int i = 0;
        int start = 0;
        int len = value.length();
        for (int f = 0; i < len && f < keys.length; ++f) {
            char c;
            boolean escaped = false;
            while (i < len && ((c = value.charAt(i)) != ';' || escaped)) {
                escaped = !escaped && c == '\\';
                ++i;
            }
            if (i > start && keys[f] != null) {
                fields.put(keys[f], VCard.vcfDecode(value.substring(start, i)));
            }
            start = ++i;
        }
    }

    private static String vcfDecode(String value) {
        if (value == null || value.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (!escaped) {
                sb.append(c);
                continue;
            }
            if (c == 'n' || c == 'N') {
                sb.append('\n');
            } else if (c == 't' || c == 'T') {
                sb.append('\t');
            } else {
                sb.append(c);
            }
            escaped = false;
        }
        return sb.toString();
    }

    public static VCard formatContact(Contact con) {
        return VCard.formatContact(con, null, false);
    }

    public static VCard formatContact(Contact con, Collection<String> vcattrs, boolean includeXProps) {
        String org;
        Date date;
        String bday;
        String n;
        Map<String, String> fields = con.getFields();
        List<Contact.Attachment> attachments = con.getAttachments();
        List<String> emails = con.getEmailAddresses();
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN:VCARD\r\n");
        if (vcattrs == null || vcattrs.contains("VERSION")) {
            sb.append("VERSION:3.0\r\n");
        }
        String fn = fields.get("fullName");
        if (vcattrs == null || vcattrs.contains("FN")) {
            if (fn == null || fn.trim().equals("")) {
                try {
                    fn = con.getFileAsString();
                }
                catch (ServiceException e) {
                    fn = "";
                }
            }
            if (fn.trim().equals("") && !emails.isEmpty()) {
                fn = emails.get(0);
            }
            sb.append("FN:").append(VCard.vcfEncode(fn)).append("\r\n");
        }
        if ((vcattrs == null || vcattrs.contains("N")) && !(n = VCard.vcfEncode(fields.get("lastName")) + ';' + VCard.vcfEncode(fields.get("firstName")) + ';' + VCard.vcfEncode(fields.get("middleName")) + ';' + VCard.vcfEncode(fields.get("namePrefix")) + ';' + VCard.vcfEncode(fields.get("nameSuffix"))).equals(";;;;")) {
            sb.append("N:").append(n).append("\r\n");
        }
        if (vcattrs == null || vcattrs.contains("NICKNAME")) {
            VCard.encodeField(sb, "NICKNAME", fields.get("nickname"));
        }
        if (vcattrs == null || vcattrs.contains("PHOTO")) {
            VCard.encodeField(sb, "PHOTO;VALUE=URI", fields.get("image"));
        }
        if ((vcattrs == null || vcattrs.contains("BDAY")) && (bday = fields.get("birthday")) != null && (date = DateUtil.parseDateSpecifier(bday)) != null) {
            sb.append("BDAY;VALUE=date:").append(new SimpleDateFormat("yyyy-MM-dd").format(date)).append("\r\n");
        }
        if (vcattrs == null || vcattrs.contains("ADR")) {
            VCard.encodeAddress(sb, "home,postal,parcel", fields.get("homeStreet"), fields.get("homeCity"), fields.get("homeState"), fields.get("homePostalCode"), fields.get("homeCountry"));
            VCard.encodeAddress(sb, "work,postal,parcel", fields.get("workStreet"), fields.get("workCity"), fields.get("workState"), fields.get("workPostalCode"), fields.get("workCountry"));
            VCard.encodeAddress(sb, "postal,parcel", fields.get("otherStreet"), fields.get("otherCity"), fields.get("otherState"), fields.get("otherPostalCode"), fields.get("otherCountry"));
        }
        if (vcattrs == null || vcattrs.contains("TEL")) {
            VCard.encodePhone(sb, "car,voice", fields.get("carPhone"));
            VCard.encodePhone(sb, "home,fax", fields.get("homeFax"));
            VCard.encodePhone(sb, "home,voice", fields.get("homePhone"));
            VCard.encodePhone(sb, "home,voice", fields.get("homePhone2"));
            VCard.encodePhone(sb, "cell,voice", fields.get("mobilePhone"));
            VCard.encodePhone(sb, "fax", fields.get("otherFax"));
            VCard.encodePhone(sb, "voice", fields.get("otherPhone"));
            VCard.encodePhone(sb, "pager", fields.get("pager"));
            VCard.encodePhone(sb, "work,fax", fields.get("workFax"));
            VCard.encodePhone(sb, "work,voice", fields.get("workPhone"));
            VCard.encodePhone(sb, "work,voice", fields.get("workPhone2"));
        }
        if (vcattrs == null || vcattrs.contains("EMAIL")) {
            for (String email : emails) {
                VCard.encodeField(sb, "EMAIL;TYPE=internet", email);
            }
        }
        if (vcattrs == null || vcattrs.contains("URL")) {
            VCard.encodeField(sb, "URL;TYPE=home", fields.get("homeURL"));
            VCard.encodeField(sb, "URL", fields.get("otherURL"));
            VCard.encodeField(sb, "URL;TYPE=work", fields.get("workURL"));
        }
        if ((vcattrs == null || vcattrs.contains("ORG")) && (org = fields.get("company")) != null && !org.trim().equals("")) {
            org = VCard.vcfEncode(org);
            String dept = fields.get("department");
            if (dept != null && !dept.trim().equals("")) {
                org = org + ';' + VCard.vcfEncode(dept);
            }
            sb.append("ORG:").append(org).append("\r\n");
        }
        if (vcattrs == null || vcattrs.contains("TITLE")) {
            VCard.encodeField(sb, "TITLE", fields.get("jobTitle"));
        }
        if (vcattrs == null || vcattrs.contains("NOTE")) {
            VCard.encodeField(sb, "NOTE", fields.get("notes"));
        }
        if ((vcattrs == null || vcattrs.contains("PHOTO")) && attachments != null) {
            for (Contact.Attachment attach : attachments) {
                try {
                    if (!attach.getName().equalsIgnoreCase("image")) continue;
                    String field = "PHOTO;ENCODING=B";
                    if (attach.getContentType().startsWith("image/")) {
                        field = field + ";TYPE=" + attach.getContentType().substring(6).toUpperCase();
                    }
                    String encoded = new String(Base64.encodeBase64Chunked((byte[])attach.getContent())).trim().replace("\r\n", "\r\n ");
                    sb.append(field).append(":\r\n ").append(encoded).append("\r\n");
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("out of memory", e);
                }
                catch (Throwable t) {
                    ZimbraLog.misc.info((Object)("error fetching attachment content: " + attach.getName()), t);
                }
            }
        }
        if (vcattrs == null || vcattrs.contains("CATEGORIES")) {
            try {
                List<Tag> tags = con.getTagList();
                if (!tags.isEmpty()) {
                    StringBuilder sbtags = new StringBuilder();
                    for (Tag tag : tags) {
                        sbtags.append(sbtags.length() == 0 ? "" : ",").append(VCard.vcfEncode(tag.getName()));
                    }
                    sb.append("CATEGORIES:").append((CharSequence)sbtags).append("\r\n");
                }
            }
            catch (ServiceException e) {
                // empty catch block
            }
        }
        String uid = VCard.getUid(con);
        if (vcattrs == null || vcattrs.contains("REV")) {
            sb.append("REV:").append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date(con.getDate()))).append("\r\n");
        }
        if (vcattrs == null || vcattrs.contains("UID")) {
            sb.append("UID:").append(uid).append("\r\n");
        }
        if (includeXProps) {
            Map<String, String> xprops = con.getXProps();
            for (String key : xprops.keySet()) {
                sb.append(key).append(":").append(xprops.get(key)).append("\r\n");
            }
        }
        sb.append("END:VCARD\r\n");
        return new VCard(fn, sb.toString(), fields, attachments, uid);
    }

    public static String getUid(Contact con) {
        String uid = con.get("vcardUID");
        if (uid != null) {
            return uid;
        }
        return con.getMailbox().getAccountId() + ":" + con.getId();
    }

    private static void encodeField(StringBuilder sb, String name, String value) {
        if (sb == null || name == null || value == null) {
            return;
        }
        sb.append(name).append(':').append(VCard.vcfEncode(value)).append("\r\n");
    }

    private static void encodeAddress(StringBuilder sb, String type, String street, String city, String state, String zip, String country) {
        if (sb == null || type == null) {
            return;
        }
        if (street == null && city == null && state == null && zip == null && country == null) {
            return;
        }
        String addr = ";;" + VCard.vcfEncode(street, true) + ';' + VCard.vcfEncode(city) + ';' + VCard.vcfEncode(state) + ';' + VCard.vcfEncode(zip) + ';' + VCard.vcfEncode(country);
        if (!addr.equals(";;;;;;")) {
            sb.append("ADR;TYPE=").append(type).append(':').append(addr).append("\r\n");
        }
    }

    private static void encodePhone(StringBuilder sb, String type, String phone) {
        if (sb == null || type == null || phone == null || phone.equals("")) {
            return;
        }
        sb.append("TEL;TYPE=").append(type).append(':').append(phone).append("\r\n");
    }

    private static String vcfEncode(String value) {
        return VCard.vcfEncode(value, false);
    }

    private static String vcfEncode(String value, boolean newlineToComma) {
        if (value == null || value.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\' || c == ',') {
                sb.append('\\').append(c);
                continue;
            }
            if (c == '\n') {
                sb.append(newlineToComma ? "," : "\\N");
                continue;
            }
            if (c != '\t' && (c < ' ' || c == '\u007f')) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws ServiceException {
        VCard.parseVCard("BEGIN:VCARD\r\n\r\nFN\n :dr. john doe\nADR;HOME;WORK:;;Hambone Ltd.\\N5 Main St.;Charlotte;NC;24243\nEMAIL:foo@bar.con\nEMAIL:bar@goo.com\nN:doe;john;\\;\\\\;dr.;;;;\nEND:VCARD\n");
        VCard.parseVCard("BEGIN:VCARD\r\n\r\nFN\n :john doe\\, jr.\nORG:Zimbra;Marketing;Annoying Marketing\nA.TEL;type=fax,WORK:+1-800-555-1212\nTEL;type=home,work,voice:+1-800-555-1313\nNOTE;QUOTED-PRINTABLE:foo=3Dbar\nc.D.e.NOTE;ENCODING=B;charset=iso-8859-1:SWYgeW91IGNhbiByZWFkIHRoaXMgeW8=\nEND:VCARD\n");
        VCard.parseVCard("BEGIN : VCARD\nFN\n :john doe\\, jr.\nAGENT:\\nBEGIN:VCARD\\nEND:VCARD\nEND:VCARD");
    }

    static {
        PARAM_ABBREVIATIONS.put("BASE64", "ENCODING=B");
        PARAM_ABBREVIATIONS.put("QUOTED-PRINTABLE", "ENCODING=QUOTED-PRINTABLE");
        PARAM_ABBREVIATIONS.put("HOME", "TYPE=HOME");
        PARAM_ABBREVIATIONS.put("WORK", "TYPE=WORK");
        PARAM_ABBREVIATIONS.put("FAX", "TYPE=FAX");
        PARAM_ABBREVIATIONS.put("CELL", "TYPE=CELL");
        PARAM_ABBREVIATIONS.put("PAGER", "TYPE=PAGER");
        PARAM_ABBREVIATIONS.put("CAR", "TYPE=CAR");
        NAME_FIELDS = new String[]{"lastName", "firstName", "middleName", "namePrefix", "nameSuffix"};
        ADR_HOME_FIELDS = new String[]{"homeStreet", "homeStreet", "homeStreet", "homeCity", "homeState", "homePostalCode", "homeCountry"};
        ADR_WORK_FIELDS = new String[]{"workStreet", "workStreet", "workStreet", "workCity", "workState", "workPostalCode", "workCountry"};
        ADR_OTHER_FIELDS = new String[]{"otherStreet", "otherStreet", "otherStreet", "otherCity", "otherState", "otherPostalCode", "otherCountry"};
        ORG_FIELDS = new String[]{"company", "department"};
        EMAIL_FIELDS = new String[]{"email", "email2", "email3"};
    }

    private static class VCardProperty {
        private String name;
        private Set<String> params = new HashSet<String>();
        private String charset;
        private Encoding encoding = Encoding.NONE;
        private String value;
        private boolean isEmpty;

        private VCardProperty() {
        }

        boolean isEmpty() {
            return this.isEmpty;
        }

        Encoding getEncoding() {
            return this.encoding;
        }

        boolean containsParam(String param) {
            return this.params.contains(param);
        }

        String getParamValue(String pname) {
            pname = pname.toUpperCase() + '=';
            for (String param : this.params) {
                if (!param.startsWith(pname)) continue;
                return param.substring(pname.length());
            }
            return null;
        }

        private void reset() {
            this.value = null;
            this.name = null;
            this.charset = "utf-8";
            this.params.clear();
            this.encoding = Encoding.NONE;
            this.isEmpty = false;
        }

        String parse(String line) throws ServiceException {
            int i;
            this.reset();
            this.isEmpty = line.trim().equals("");
            if (this.isEmpty) {
                return "";
            }
            int colon = line.indexOf(58);
            if (colon == -1) {
                throw ServiceException.PARSE_ERROR("missing ':' in line " + line, null);
            }
            this.value = line.substring(colon + 1);
            char c = '\u0000';
            int start = 0;
            for (i = 0; i < colon; ++i) {
                c = line.charAt(i);
                if (c == '.') {
                    start = i + 1;
                    continue;
                }
                if (c == ';') break;
            }
            this.name = line.substring(start, i).trim().toUpperCase();
            String pname = null;
            while (i < colon) {
                start = ++i;
                while (i < colon && (c = line.charAt(i)) != ';' && (c != ',' || pname == null)) {
                    if (c == '=' && pname == null && i > start) {
                        pname = line.substring(start, i).toUpperCase();
                        start = i + 1;
                    }
                    ++i;
                }
                String pval = line.substring(start, i).toUpperCase();
                if (!pval.equals("")) {
                    String param = pname != null ? pname + '=' + pval : PARAM_ABBREVIATIONS.get(pval);
                    if (param == null) continue;
                    if (param.equals("ENCODING=B")) {
                        this.encoding = Encoding.B;
                    } else if (param.equals("ENCODING=BASE64")) {
                        this.encoding = Encoding.B;
                    } else if (param.equals("ENCODING=QUOTED-PRINTABLE")) {
                        this.encoding = Encoding.Q;
                    } else if (pname != null && pname.equals("CHARSET")) {
                        this.charset = pval;
                    } else {
                        this.params.add(param);
                    }
                }
                if (c != ';') continue;
                pname = null;
            }
            return this.name;
        }

        String getValue() {
            try {
                if (this.encoding == Encoding.B) {
                    byte[] encoded = this.value.getBytes();
                    if (Base64.isArrayByteBase64((byte[])encoded)) {
                        this.value = new String(Base64.decodeBase64((byte[])encoded), this.charset);
                    }
                } else if (this.encoding == Encoding.Q) {
                    this.value = new QuotedPrintableCodec(this.charset).decode(this.value);
                }
                this.encoding = Encoding.NONE;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.value;
        }

        byte[] getDecoded() {
            byte[] encoded = this.value.getBytes();
            try {
                if (this.encoding == Encoding.B && Base64.isArrayByteBase64((byte[])encoded)) {
                    encoded = Base64.decodeBase64((byte[])encoded);
                }
                this.encoding = Encoding.NONE;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return encoded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Encoding {
        NONE,
        B,
        Q;

    }
}

