/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.ArchiveFormatter;
import com.zimbra.cs.service.formatter.TarFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TgzFormatter
extends TarFormatter {
    public String[] getDefaultMimeTypes() {
        return new String[]{"application/x-compressed-tar"};
    }

    public String getType() {
        return "tgz";
    }

    protected ArchiveFormatter.ArchiveInputStream getInputStream(UserServlet.Context context, String charset) throws IOException, ServiceException, UserServletException {
        return new TarFormatter.TarArchiveInputStream(new GZIPInputStream(context.getRequestInputStream(-1L)), charset);
    }

    protected ArchiveFormatter.ArchiveOutputStream getOutputStream(UserServlet.Context context, String charset) throws IOException {
        return new TarFormatter.TarArchiveOutputStream(new GZIPOutputStream((OutputStream)context.resp.getOutputStream()), charset);
    }
}

