/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.tar.TarEntry;
import com.zimbra.common.util.tar.TarInputStream;
import com.zimbra.common.util.tar.TarOutputStream;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.ArchiveFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarFormatter
extends ArchiveFormatter {
    public String[] getDefaultMimeTypes() {
        return new String[]{"application/x-tar"};
    }

    public String getType() {
        return "tar";
    }

    protected ArchiveFormatter.ArchiveInputStream getInputStream(UserServlet.Context context, String charset) throws IOException, ServiceException, UserServletException {
        return new TarArchiveInputStream(context.getRequestInputStream(-1L), charset);
    }

    protected ArchiveFormatter.ArchiveOutputStream getOutputStream(UserServlet.Context context, String charset) throws IOException {
        return new TarArchiveOutputStream((OutputStream)context.resp.getOutputStream(), charset);
    }

    public class TarArchiveOutputStream
    implements ArchiveFormatter.ArchiveOutputStream {
        private TarOutputStream os;

        public TarArchiveOutputStream(OutputStream os, String cset) throws IOException {
            this.os = new TarOutputStream(os, cset);
            this.os.setLongFileMode(2);
        }

        public void close() throws IOException {
            this.os.close();
        }

        public void closeEntry() throws IOException {
            this.os.closeEntry();
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        public int getRecordSize() {
            return this.os.getRecordSize();
        }

        public ArchiveFormatter.ArchiveOutputEntry newOutputEntry(String path, String name, int type, long date) {
            return new TarArchiveOutputEntry(path, name, type, date);
        }

        public void putNextEntry(ArchiveFormatter.ArchiveOutputEntry entry) throws IOException {
            this.os.putNextEntry(((TarArchiveOutputEntry)entry).entry);
        }

        public void write(byte[] buf) throws IOException {
            this.os.write(buf);
        }

        public void write(byte[] buf, int offset, int len) throws IOException {
            this.os.write(buf, offset, len);
        }

        public class TarArchiveOutputEntry
        implements ArchiveFormatter.ArchiveOutputEntry {
            private TarEntry entry;

            public TarArchiveOutputEntry(String path, String name, int type, long date) {
                this.entry = new TarEntry(path);
                this.entry.setGroupName(name);
                this.entry.setMajorDeviceId(type);
                this.entry.setModTime(date);
            }

            public void setUnread() {
                this.entry.setMode(this.entry.getMode() & 0xFFFFFF7F);
            }

            public void setSize(long size) {
                this.entry.setSize(size);
            }
        }
    }

    public class TarArchiveInputStream
    implements ArchiveFormatter.ArchiveInputStream {
        private TarInputStream is;

        public TarArchiveInputStream(InputStream is, String cset) {
            this.is = new TarInputStream(is, cset);
        }

        public void close() throws IOException {
            this.is.close();
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public ArchiveFormatter.ArchiveInputEntry getNextEntry() throws IOException {
            TarArchiveInputEntry taie = new TarArchiveInputEntry(this.is);
            return taie.entry == null ? null : taie;
        }

        public int read(byte[] buf, int offset, int len) throws IOException {
            return this.is.read(buf, offset, len);
        }

        public class TarArchiveInputEntry
        implements ArchiveFormatter.ArchiveInputEntry {
            private TarEntry entry;

            public TarArchiveInputEntry(TarInputStream is) throws IOException {
                this.entry = is.getNextEntry();
            }

            public long getModTime() {
                return this.entry.getModTime().getTime();
            }

            public String getName() {
                return this.entry.getName();
            }

            public long getSize() {
                return this.entry.getSize();
            }

            public int getType() {
                return this.entry.getMajorDeviceId();
            }

            public boolean isUnread() {
                return (this.entry.getMode() & 0x80) == 0;
            }
        }
    }
}

