/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.service.formatter.HeadersOnlyInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncFormatter
extends Formatter {
    public static final String QP_NOHDR = "nohdr";

    @Override
    public String getType() {
        return "sync";
    }

    @Override
    public String getDefaultSearchTypes() {
        return "message";
    }

    private static List<Pair<String, String>> getXZimbraHeaders(MailItem item) {
        ArrayList<Pair<String, String>> hdrs = new ArrayList<Pair<String, String>>();
        hdrs.add(new Pair<String, String>("X-Zimbra-ItemId", item.getId() + ""));
        hdrs.add(new Pair<String, String>("X-Zimbra-FolderId", item.getFolderId() + ""));
        hdrs.add(new Pair<String, String>("X-Zimbra-Tags", item.getTagString()));
        hdrs.add(new Pair<String, String>("X-Zimbra-Flags", item.getFlagString()));
        hdrs.add(new Pair<String, String>("X-Zimbra-Received", item.getDate() + ""));
        hdrs.add(new Pair<String, String>("X-Zimbra-Modified", item.getChangeDate() + ""));
        hdrs.add(new Pair<String, String>("X-Zimbra-Change", item.getModifiedSequence() + ""));
        hdrs.add(new Pair<String, String>("X-Zimbra-Revision", item.getSavedSequence() + ""));
        if (item instanceof Message) {
            hdrs.add(new Pair<String, String>("X-Zimbra-Conv", ((Message)item).getConversationId() + ""));
        }
        return hdrs;
    }

    private static byte[] getXZimbraHeadersBytes(List<Pair<String, String>> hdrs) {
        StringBuilder sb = new StringBuilder();
        for (Pair<String, String> pair : hdrs) {
            sb.append(pair.getFirst()).append(": ").append(pair.getSecond()).append("\r\n");
        }
        return sb.toString().getBytes();
    }

    public static byte[] getXZimbraHeadersBytes(MailItem item) {
        return SyncFormatter.getXZimbraHeadersBytes(SyncFormatter.getXZimbraHeaders(item));
    }

    private static void addXZimbraHeaders(UserServlet.Context context, MailItem item, long size) throws IOException {
        List<Pair<String, String>> hdrs = SyncFormatter.getXZimbraHeaders(item);
        for (Pair<String, String> pair : hdrs) {
            context.resp.addHeader(pair.getFirst(), pair.getSecond());
        }
        if (context.params.get(QP_NOHDR) == null) {
            byte[] inline = SyncFormatter.getXZimbraHeadersBytes(hdrs);
            if (size > 0L) {
                context.resp.setContentLength(inline.length + (int)size);
            }
            context.resp.getOutputStream().write(inline);
        } else if (size > 0L) {
            context.resp.setContentLength((int)size);
        }
    }

    @Override
    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException, UserServletException {
        try {
            if (context.hasPart()) {
                this.handleMessagePart(context, context.target);
            } else if (context.target instanceof Message) {
                this.handleMessage(context, (Message)context.target);
            } else if (context.target instanceof CalendarItem) {
                CalendarItem calItem = (CalendarItem)context.target;
                if (calItem.isPublic() || calItem.allowPrivateAccess(context.authAccount, context.isUsingAdminPrivileges())) {
                    this.handleCalendarItem(context, calItem);
                } else {
                    context.resp.sendError(403, "permission denied");
                }
            }
        }
        catch (MessagingException me) {
            throw ServiceException.FAILURE(me.getMessage(), me);
        }
    }

    private void handleCalendarItem(UserServlet.Context context, CalendarItem calItem) throws IOException, ServiceException, MessagingException {
        context.resp.setContentType("text/plain");
        if (context.itemId.hasSubpart()) {
            Pair<MimeMessage, Integer> calItemMsgData = calItem.getSubpartMessageData(context.itemId.getSubpartId());
            if (calItemMsgData != null) {
                SyncFormatter.addXZimbraHeaders(context, calItem, calItemMsgData.getSecond().intValue());
                calItemMsgData.getFirst().writeTo((OutputStream)context.resp.getOutputStream());
            } else {
                Invite invite;
                MimeMessage mm;
                int invId = context.itemId.getSubpartId();
                Invite[] invs = calItem.getInvites(invId);
                if (invs != null && invs.length > 0 && (mm = CalendarMailSender.createCalendarMessage(invite = invs[0])) != null) {
                    int sizeHint = mm.getSize();
                    if (sizeHint < 0) {
                        sizeHint = 0;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(sizeHint);
                    mm.writeTo((OutputStream)baos);
                    byte[] bytes = baos.toByteArray();
                    SyncFormatter.addXZimbraHeaders(context, calItem, bytes.length);
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    ByteUtil.copy(bais, true, (OutputStream)context.resp.getOutputStream(), false);
                }
            }
        } else {
            SyncFormatter.addXZimbraHeaders(context, calItem, calItem.getSize());
            InputStream is = calItem.getRawMessage();
            if (is != null) {
                ByteUtil.copy(is, true, (OutputStream)context.resp.getOutputStream(), false);
            }
        }
    }

    private void handleMessage(UserServlet.Context context, Message msg) throws IOException, ServiceException {
        context.resp.setContentType("text/plain");
        InputStream is = msg.getContentStream();
        long size = msg.getSize();
        if (!context.shouldReturnBody()) {
            byte[] headers = HeadersOnlyInputStream.getHeaders(is);
            is = new ByteArrayInputStream(headers);
            size = headers.length;
        }
        SyncFormatter.addXZimbraHeaders(context, msg, size);
        ByteUtil.copy(is, true, (OutputStream)context.resp.getOutputStream(), false);
    }

    private void handleMessagePart(UserServlet.Context context, MailItem item) throws IOException, ServiceException, MessagingException, UserServletException {
        if (!(item instanceof Message)) {
            throw UserServletException.notImplemented("can only handle messages");
        }
        Message message = (Message)item;
        MimePart mp = SyncFormatter.getMimePart(message, context.getPart());
        if (mp != null) {
            String contentType = mp.getContentType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            SyncFormatter.sendbackOriginalDoc(mp, contentType, context.req, context.resp);
            return;
        }
        context.resp.sendError(400, "part not found");
    }

    public static MimePart getMimePart(CalendarItem calItem, String part) throws IOException, MessagingException, ServiceException {
        return Mime.getMimePart((MimePart)calItem.getMimeMessage(), part);
    }

    public static MimePart getMimePart(Message msg, String part) throws IOException, MessagingException, ServiceException {
        return Mime.getMimePart((MimePart)msg.getMimeMessage(), part);
    }

    public static void sendbackOriginalDoc(MimePart mp, String contentType, HttpServletRequest req, HttpServletResponse resp) throws IOException, MessagingException {
        String filename = Mime.getFilename(mp);
        if (filename == null) {
            filename = "unknown";
        }
        String cd = "inline; filename=" + HttpUtil.encodeFilename(req, filename);
        resp.addHeader("Content-Disposition", cd);
        String desc = mp.getDescription();
        if (desc != null) {
            resp.addHeader("Content-Description", desc);
        }
        SyncFormatter.sendbackOriginalDoc(mp.getInputStream(), contentType, resp);
    }

    public static void sendbackOriginalDoc(InputStream is, String contentType, HttpServletResponse resp) throws IOException {
        resp.setContentType(contentType);
        ByteUtil.copy(is, true, (OutputStream)resp.getOutputStream(), false);
    }

    @Override
    public boolean canBeBlocked() {
        return true;
    }

    @Override
    public boolean supportsSave() {
        return true;
    }

    @Override
    public void saveCallback(UserServlet.Context context, String contentType, Folder folder, String filename) throws IOException, ServiceException, UserServletException {
        byte[] body = context.getPostBody();
        try {
            Mailbox mbox = folder.getMailbox();
            ParsedMessage pm = new ParsedMessage(body, mbox.attachmentsIndexingEnabled());
            mbox.addMessage(context.opContext, pm, folder.getId(), true, 0, null);
        }
        catch (ServiceException e) {
            throw new UserServletException(400, "error parsing message");
        }
    }
}

