/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.formatter.Formatter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class RssFormatter
extends Formatter {
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException {
        Iterator<? extends MailItem> iterator = null;
        StringBuffer sb = new StringBuffer();
        Element.XMLElement rss = new Element.XMLElement("rss");
        int offset = context.getOffset();
        int limit = context.getLimit();
        try {
            iterator = this.getMailItems(context, context.getStartTime(), context.getEndTime(), limit - offset);
            context.resp.setCharacterEncoding("UTF-8");
            context.resp.setContentType("application/rss+xml");
            sb.append("<?xml version=\"1.0\"?>\n");
            rss.addAttribute("version", "2.0");
            Element channel = rss.addElement("channel");
            channel.addElement("title").setText("Zimbra " + context.itemPath);
            channel.addElement("link").setText("http://www.zimbra.com");
            channel.addElement("description").setText("Zimbra item " + context.itemPath + " in RSS format.");
            channel.addElement("generator").setText("Zimbra RSS Feed Servlet");
            int curHit = 0;
            while (iterator.hasNext()) {
                MailItem itItem = iterator.next();
                if (++curHit > limit) break;
                if (curHit < offset) continue;
                if (itItem instanceof CalendarItem) {
                    CalendarItem calItem = (CalendarItem)itItem;
                    if (!calItem.isPublic() && !calItem.allowPrivateAccess(context.authAccount, context.isUsingAdminPrivileges())) continue;
                    this.addCalendarItem(calItem, channel, context);
                    continue;
                }
                if (itItem instanceof Message) {
                    this.addMessage((Message)itItem, channel, context);
                    continue;
                }
                if (!(itItem instanceof Document)) continue;
                this.addDocument((Document)itItem, channel, context);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (iterator instanceof Formatter.QueryResultIterator) {
                ((Formatter.QueryResultIterator)iterator).finished();
            }
            throw throwable;
        }
        if (iterator instanceof Formatter.QueryResultIterator) {
            ((Formatter.QueryResultIterator)iterator).finished();
        }
        sb.append(rss.toString());
        context.resp.getOutputStream().write(sb.toString().getBytes("UTF-8"));
    }

    public long getDefaultStartTime() {
        return System.currentTimeMillis() - 604800000L;
    }

    public long getDefaultEndTime() {
        return System.currentTimeMillis() + 604800000L;
    }

    private void addCalendarItem(CalendarItem calItem, Element channel, UserServlet.Context context) throws ServiceException {
        Collection<CalendarItem.Instance> instances = calItem.expandInstances(context.getStartTime(), context.getEndTime(), false);
        for (CalendarItem.Instance inst : instances) {
            InviteInfo invId = inst.getInviteInfo();
            Invite inv = calItem.getInvite(invId.getMsgId(), invId.getComponentId());
            Element rssItem = channel.addElement("item");
            rssItem.addElement("title").setText(inv.getName());
            rssItem.addElement("pubDate").setText(this.mDateFormat.format(new Date(inst.getStart())));
            rssItem.addElement("description").setText(inv.getFragment());
            if (!inv.hasOrganizer()) continue;
            rssItem.addElement("author").setText(inv.getOrganizer().getAddress());
        }
    }

    private void addMessage(Message m, Element channel, UserServlet.Context context) {
        Element item = channel.addElement("item");
        item.addElement("title").setText(m.getSubject());
        item.addElement("description").setText(m.getFragment());
        item.addElement("author").setText(m.getSender());
        item.addElement("pubDate").setText(this.mDateFormat.format(new Date(m.getDate())));
    }

    private void addDocument(Document doc, Element channel, UserServlet.Context context) {
        Element item = channel.addElement("item");
        item.addElement("title").setText(doc.getName() + " ver " + doc.getVersion());
        item.addElement("description").setText(doc.getFragment());
        item.addElement("author").setText(doc.getCreator());
        item.addElement("pubDate").setText(this.mDateFormat.format(new Date(doc.getDate())));
        item.addElement("link").setText(context.req.getRequestURL().append("?id=" + doc.getId()).toString());
    }

    public String getType() {
        return "rss";
    }

    public boolean canBeBlocked() {
        return false;
    }
}

