/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.mime.MimeDetect;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.cs.html.HtmlDefang;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedDocument;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NativeFormatter
extends Formatter {
    private static final String CONVERSION_PATH = "/extension/convertd";
    public static final String ATTR_INPUTSTREAM = "inputstream";
    public static final String ATTR_MSGDIGEST = "msgdigest";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_CONTENTURL = "contenturl";
    public static final String ATTR_CONTENTTYPE = "contenttype";
    public static final String ATTR_CONTENTLENGTH = "contentlength";
    public static final String FMT_NATIVE = "native";
    private static final String HTML_VIEW = "html";
    private static final int READ_AHEAD_BUFFER_SIZE = 256;
    private static final byte[][] SCRIPT_PATTERN = new byte[][]{{60, 115, 99, 114, 105, 112, 116}, {60, 83, 67, 82, 73, 80, 84}};

    public String getType() {
        return FMT_NATIVE;
    }

    public String getDefaultSearchTypes() {
        return "message";
    }

    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException, UserServletException, ServletException {
        block8: {
            try {
                this.sendZimbraHeaders(context.resp, context.target);
                if (context.target instanceof Message) {
                    this.handleMessage(context, (Message)context.target);
                    break block8;
                }
                if (context.target instanceof CalendarItem) {
                    CalendarItem calItem = (CalendarItem)context.target;
                    if (calItem.isPublic() || calItem.allowPrivateAccess(context.authAccount, context.isUsingAdminPrivileges())) {
                        this.handleCalendarItem(context, calItem);
                    } else {
                        context.resp.sendError(403, "permission denied");
                    }
                    break block8;
                }
                if (context.target instanceof Document) {
                    this.handleDocument(context, (Document)context.target);
                    break block8;
                }
                if (context.target instanceof Contact) {
                    this.handleContact(context, (Contact)context.target);
                    break block8;
                }
                throw UserServletException.notImplemented("can only handle messages/appointments/tasks/documents");
            }
            catch (MessagingException me) {
                throw ServiceException.FAILURE(me.getMessage(), me);
            }
        }
    }

    private void handleMessage(UserServlet.Context context, Message msg) throws IOException, ServiceException, MessagingException, ServletException {
        if (context.hasBody()) {
            List<MPartInfo> parts = Mime.getParts(msg.getMimeMessage());
            MPartInfo body = Mime.getTextBody(parts, false);
            if (body != null) {
                this.handleMessagePart(context, body.getMimePart(), msg);
            } else {
                context.resp.sendError(400, "body not found");
            }
        } else if (context.hasPart()) {
            MimePart mp = NativeFormatter.getMimePart(msg, context.getPart());
            this.handleMessagePart(context, mp, msg);
        } else {
            context.resp.setContentType("text/plain");
            long size = msg.getSize();
            if (size > 0L) {
                context.resp.setContentLength((int)size);
            }
            InputStream is = msg.getContentStream();
            ByteUtil.copy(is, true, (OutputStream)context.resp.getOutputStream(), false);
        }
    }

    private void handleCalendarItem(UserServlet.Context context, CalendarItem calItem) throws IOException, ServiceException, MessagingException, ServletException {
        if (context.hasPart()) {
            MimePart mp = null;
            if (context.itemId.hasSubpart()) {
                MimeMessage mbp = calItem.getSubpartMessage(context.itemId.getSubpartId());
                mp = Mime.getMimePart((MimePart)mbp, context.getPart());
            } else {
                mp = NativeFormatter.getMimePart(calItem, context.getPart());
            }
            this.handleMessagePart(context, mp, calItem);
        } else {
            context.resp.setContentType("text/plain");
            InputStream is = calItem.getRawMessage();
            if (is != null) {
                ByteUtil.copy(is, true, (OutputStream)context.resp.getOutputStream(), false);
            }
        }
    }

    private void handleContact(UserServlet.Context context, Contact con) throws IOException, ServiceException, MessagingException, ServletException {
        if (!con.hasAttachment()) {
            context.resp.sendError(400, "body not found");
        } else if (context.hasPart()) {
            MimePart mp = Mime.getMimePart((MimePart)con.getMimeMessage(false), context.getPart());
            this.handleMessagePart(context, mp, con);
        } else {
            context.resp.setContentType("text/plain");
            ByteArrayInputStream is = new ByteArrayInputStream(con.getContent());
            ByteUtil.copy(is, true, (OutputStream)context.resp.getOutputStream(), false);
        }
    }

    private void handleMessagePart(UserServlet.Context context, MimePart mp, MailItem item) throws IOException, MessagingException, ServletException {
        if (mp == null) {
            context.resp.sendError(400, "part not found");
        } else {
            boolean html;
            String contentType = mp.getContentType();
            if (contentType == null) {
                contentType = "text/plain";
            } else if (contentType.equals("application/octet-stream") && (contentType = MimeDetect.getMimeDetect().detect(Mime.getFilename(mp), mp.getInputStream())) == null) {
                contentType = "application/octet-stream";
            }
            contentType = contentType.replace('\r', ' ').replace('\n', ' ');
            boolean bl = html = NativeFormatter.checkGlobalOverride("zimbraAttachmentsViewInHtmlOnly", context.authAccount) || context.hasView() && context.getView().equals(HTML_VIEW);
            if (!html) {
                String defaultCharset = context.targetAccount.getAttr("zimbraPrefMailDefaultCharset", null);
                NativeFormatter.sendbackOriginalDoc(mp, contentType, defaultCharset, context.req, context.resp);
            } else {
                this.handleConversion(context, mp.getInputStream(), Mime.getFilename(mp), contentType, item.getDigest(), mp.getSize());
            }
        }
    }

    private void handleDocument(UserServlet.Context context, Document doc) throws IOException, ServiceException, ServletException {
        String v = context.params.get("ver");
        int version = v != null ? Integer.parseInt(v) : -1;
        String contentType = doc.getContentType();
        doc = version > 0 ? (Document)doc.getMailbox().getItemRevision(context.opContext, doc.getId(), doc.getType(), version) : doc;
        InputStream is = doc.getContentStream();
        if (HTML_VIEW.equals(context.getView())) {
            this.handleConversion(context, is, doc.getName(), doc.getContentType(), doc.getDigest(), doc.getSize());
        } else {
            String defaultCharset = context.targetAccount.getAttr("zimbraPrefMailDefaultCharset", null);
            boolean neuter = doc.getAccount().getBooleanAttr("zimbraNotebookSanitizeHtml", true);
            if (neuter) {
                NativeFormatter.sendbackOriginalDoc(is, contentType, defaultCharset, doc.getName(), null, doc.getSize(), context.req, context.resp);
            } else {
                NativeFormatter.sendbackBinaryData(context.req, context.resp, is, null, doc.getName(), doc.getSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConversion(UserServlet.Context ctxt, InputStream is, String filename, String ct, String digest, long length) throws IOException, ServletException {
        try {
            ctxt.req.setAttribute(ATTR_INPUTSTREAM, (Object)is);
            ctxt.req.setAttribute(ATTR_MSGDIGEST, (Object)digest);
            ctxt.req.setAttribute(ATTR_FILENAME, (Object)filename);
            ctxt.req.setAttribute(ATTR_CONTENTTYPE, (Object)ct);
            ctxt.req.setAttribute(ATTR_CONTENTURL, (Object)ctxt.req.getRequestURL().toString());
            ctxt.req.setAttribute(ATTR_CONTENTLENGTH, (Object)length);
            RequestDispatcher dispatcher = ctxt.req.getRequestDispatcher(CONVERSION_PATH);
            dispatcher.forward((ServletRequest)ctxt.req, (ServletResponse)ctxt.resp);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    public static MimePart getMimePart(CalendarItem calItem, String part) throws IOException, MessagingException, ServiceException {
        return Mime.getMimePart((MimePart)calItem.getMimeMessage(), part);
    }

    public static MimePart getMimePart(Message msg, String part) throws IOException, MessagingException, ServiceException {
        return Mime.getMimePart((MimePart)msg.getMimeMessage(), part);
    }

    public static void sendbackOriginalDoc(MimePart mp, String contentType, String defaultCharset, HttpServletRequest req, HttpServletResponse resp) throws IOException, MessagingException {
        String enc = mp.getEncoding();
        if (enc != null) {
            enc = enc.toLowerCase();
        }
        long size = enc == null || enc.equals("7bit") || enc.equals("8bit") || enc.equals("binary") ? (long)mp.getSize() : 0L;
        NativeFormatter.sendbackOriginalDoc(mp.getInputStream(), contentType, defaultCharset, Mime.getFilename(mp), mp.getDescription(), size, req, resp);
    }

    public static void sendbackOriginalDoc(InputStream is, String contentType, String defaultCharset, String filename, String desc, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        NativeFormatter.sendbackOriginalDoc(is, contentType, defaultCharset, filename, desc, 0L, req, resp);
    }

    public static void sendbackOriginalDoc(InputStream is, String contentType, String defaultCharset, String filename, String desc, long size, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String disp = req.getParameter("disp");
        String string = disp = disp == null || disp.toLowerCase().startsWith("i") ? "inline" : "attachment";
        if (desc != null) {
            resp.addHeader("Content-Description", desc);
        }
        resp.setContentType(contentType);
        if (contentType.startsWith("text/html") && disp.equals("inline")) {
            String content;
            String charset = Mime.getCharset(contentType);
            if (charset != null && !charset.equals("")) {
                Reader reader = Mime.getTextReader(is, contentType, defaultCharset);
                content = HtmlDefang.defang(reader, false);
            } else {
                content = HtmlDefang.defang(is, false);
            }
            if (content.length() > 0) {
                resp.setContentLength(content.length());
            }
            resp.getWriter().write(content);
        } else {
            NativeFormatter.sendbackBinaryData(req, resp, is, disp, filename, size);
        }
    }

    public boolean canBeBlocked() {
        return true;
    }

    public boolean supportsSave() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCallback(UserServlet.Context context, String contentType, Folder folder, String filename) throws IOException, ServiceException, UserServletException {
        MailItem item;
        block8: {
            Mailbox mbox = folder.getMailbox();
            item = null;
            if (filename == null) {
                try {
                    ParsedMessage pm = new ParsedMessage(context.getPostBody(), mbox.attachmentsIndexingEnabled());
                    item = mbox.addMessage(context.opContext, pm, folder.getId(), true, 0, null);
                    return;
                }
                catch (ServiceException e) {
                    throw new UserServletException(400, "error parsing message");
                }
            }
            String creator = context.authAccount == null ? null : context.authAccount.getName();
            InputStream is = context.getRequestInputStream();
            ParsedDocument pd = null;
            try {
                try {
                    pd = new ParsedDocument(is, filename, contentType, System.currentTimeMillis(), creator);
                    item = mbox.getItemByPath(context.opContext, filename, folder.getId());
                    if (!(item instanceof Document)) {
                        throw new UserServletException(400, "cannot overwrite existing object at that path");
                    }
                    item = mbox.addDocumentRevision(context.opContext, item.getId(), pd);
                }
                catch (MailServiceException.NoSuchItemException nsie) {
                    item = mbox.createDocument(context.opContext, folder.getId(), pd, (byte)8);
                    Object var12_13 = null;
                    is.close();
                    break block8;
                }
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                is.close();
                throw throwable;
            }
            is.close();
        }
        this.sendZimbraHeaders(context.resp, item);
    }

    private void sendZimbraHeaders(HttpServletResponse resp, MailItem item) {
        if (resp == null || item == null) {
            return;
        }
        resp.addHeader("X-Zimbra-ItemId", item.getId() + "");
        resp.addHeader("X-Zimbra-Version", item.getVersion() + "");
        resp.addHeader("X-Zimbra-Modified", item.getChangeDate() + "");
        resp.addHeader("X-Zimbra-Change", item.getModifiedSequence() + "");
        resp.addHeader("X-Zimbra-Revision", item.getSavedSequence() + "");
        resp.addHeader("X-Zimbra-ItemType", MailItem.getNameForType(item));
        resp.addHeader("X-Zimbra-ItemName", item.getName());
        try {
            resp.addHeader("X-Zimbra-ItemPath", item.getPath());
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public static void sendbackBinaryData(HttpServletRequest req, HttpServletResponse resp, InputStream in, String disposition, String filename, long size) throws IOException {
        if (disposition == null) {
            String disp = req.getParameter("disp");
            disposition = disp == null || disp.toLowerCase().startsWith("i") ? "inline" : "attachment";
        }
        PushbackInputStream pis = new PushbackInputStream(in, 256);
        boolean isSafe = false;
        String ua = req.getHeader("User-Agent");
        if (ua == null || ua.indexOf("MSIE") == -1) {
            isSafe = true;
        }
        if (disposition != null && disposition.equals("attachment")) {
            isSafe = true;
        }
        if (!isSafe) {
            byte[] buf = new byte[256];
            int bytesRead = pis.read(buf, 0, 256);
            boolean hasScript = false;
            for (int i = 0; i < bytesRead; ++i) {
                if (buf[i] != SCRIPT_PATTERN[0][0] && buf[i] != SCRIPT_PATTERN[1][0]) continue;
                hasScript = true;
                for (int pos = 1; pos < 7 && i + pos < bytesRead; ++pos) {
                    if (buf[i + pos] == SCRIPT_PATTERN[0][pos] || buf[i + pos] == SCRIPT_PATTERN[1][pos]) continue;
                    hasScript = false;
                    break;
                }
                if (!hasScript) continue;
                resp.addHeader("Cache-Control", "no-transform");
                disposition = "attachment";
                break;
            }
            if (bytesRead > 0) {
                pis.unread(buf, 0, bytesRead);
            }
        }
        if (disposition != null) {
            String cd = disposition + "; filename=" + HttpUtil.encodeFilename(req, filename == null ? "unknown" : filename);
            resp.addHeader("Content-Disposition", cd);
        }
        if (size > 0L) {
            resp.setContentLength((int)size);
        }
        ByteUtil.copy(pis, true, (OutputStream)resp.getOutputStream(), false);
    }
}

