/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import java.io.IOException;

public class IfbFormatter
extends Formatter {
    private static final long ONE_MONTH = 2678400000L;

    public String getType() {
        return "ifb";
    }

    public boolean requiresAuth() {
        return false;
    }

    public String getDefaultSearchTypes() {
        return "appointment";
    }

    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException, UserServletException {
        context.resp.setCharacterEncoding("UTF-8");
        context.resp.setContentType("text/calendar");
        long rangeStart = Math.max(context.getStartTime(), this.getDefaultStartTime());
        long rangeEnd = Math.max(context.getEndTime(), this.getDefaultEndTime());
        if (rangeEnd < rangeStart) {
            throw new UserServletException(400, "End time must be after Start time");
        }
        long days = (rangeEnd - rangeStart) / 86400000L;
        long maxDays = LC.calendar_freebusy_max_days.longValueWithinRange(0L, 36600L);
        if (days > maxDays) {
            throw new UserServletException(400, "Requested range is too large (Maximum " + maxDays + " days)");
        }
        String url = context.req.getRequestURL() + "?" + context.req.getQueryString();
        String acctName = null;
        FreeBusy fb = null;
        if (context.targetMailbox != null) {
            CalendarItem ci;
            String exuid = context.params.get("exuid");
            Appointment exAppt = null;
            if (exuid != null && (ci = context.targetMailbox.getCalendarItemByUid(context.opContext, exuid)) instanceof Appointment) {
                exAppt = (Appointment)ci;
            }
            acctName = context.targetMailbox.getAccount().getName();
            fb = context.targetMailbox.getFreeBusy(context.opContext, acctName, rangeStart, rangeEnd, context.getFreeBusyCalendar(), exAppt);
        } else {
            acctName = this.fixupAccountName(context.accountPath);
            fb = FreeBusy.emptyFreeBusy(acctName, rangeStart, rangeEnd);
        }
        String fbMsg = fb.toVCalendar(FreeBusy.Method.PUBLISH, acctName, null, url);
        context.resp.getOutputStream().write(fbMsg.getBytes("UTF-8"));
    }

    public long getDefaultStartTime() {
        return System.currentTimeMillis() - 2678400000L;
    }

    public long getDefaultEndTime() {
        return System.currentTimeMillis() + 5356800000L;
    }

    public boolean canBeBlocked() {
        return false;
    }

    private String fixupAccountName(String emailAddress) throws ServiceException {
        int index = emailAddress.indexOf(64);
        String domain = null;
        if (index == -1) {
            domain = Provisioning.getInstance().getConfig().getAttr("zimbraDefaultDomainName", null);
            if (domain != null) {
                emailAddress = emailAddress + "@" + domain;
            }
        } else {
            emailAddress = IDNUtil.toAsciiEmail(emailAddress);
        }
        return emailAddress;
    }
}

