/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.FileBufferedWriter;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.IcsImportParseHandler;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;

public class IcsFormatter
extends Formatter {
    public String getType() {
        return "ics";
    }

    public String[] getDefaultMimeTypes() {
        return new String[]{"text/calendar", "text/x-vcalendar"};
    }

    public String getDefaultSearchTypes() {
        return "appointment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException {
        Iterator<? extends MailItem> iterator = null;
        ArrayList<CalendarItem> calItems = new ArrayList<CalendarItem>();
        try {
            long start = context.getStartTime();
            long end = context.getEndTime();
            iterator = this.getMailItems(context, start, end, Integer.MAX_VALUE);
            while (iterator.hasNext()) {
                CalendarItem calItem;
                Collection<CalendarItem.Instance> instances;
                MailItem item = iterator.next();
                if (!(item instanceof CalendarItem) || (instances = (calItem = (CalendarItem)item).expandInstances(start, end, false)).isEmpty()) continue;
                calItems.add(calItem);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (iterator instanceof Formatter.QueryResultIterator) {
                ((Formatter.QueryResultIterator)iterator).finished();
            }
            throw throwable;
        }
        if (iterator instanceof Formatter.QueryResultIterator) {
            ((Formatter.QueryResultIterator)iterator).finished();
        }
        String filename = context.itemPath;
        if (filename == null || filename.length() == 0) {
            filename = "contacts";
        }
        String cd = "attachment; filename=" + HttpUtil.encodeFilename(context.req, filename + ".ics");
        context.resp.addHeader("Content-Disposition", cd);
        context.resp.setCharacterEncoding("utf-8");
        context.resp.setContentType("text/calendar");
        HttpUtil.Browser browser = HttpUtil.guessBrowser(context.req);
        boolean useOutlookCompatMode = HttpUtil.Browser.IE.equals((Object)browser);
        boolean needAppleICalHacks = HttpUtil.Browser.APPLE_ICAL.equals((Object)browser);
        OperationContext octxt = new OperationContext(context.authAccount, context.isUsingAdminPrivileges());
        FileBufferedWriter fileBufferedWriter = new FileBufferedWriter(context.resp.getWriter(), LC.calendar_ics_export_buffer_size.intValueWithinRange(0, 0xA00000));
        try {
            context.targetMailbox.writeICalendarForCalendarItems(fileBufferedWriter, octxt, calItems, useOutlookCompatMode, true, needAppleICalHacks, true);
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            fileBufferedWriter.finish();
            throw throwable;
        }
        fileBufferedWriter.finish();
    }

    public long getDefaultStartTime() {
        return 0L;
    }

    public long getDefaultEndTime() {
        return System.currentTimeMillis() + 3153600000000L;
    }

    public boolean canBeBlocked() {
        return false;
    }

    public boolean supportsSave() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCallback(UserServlet.Context context, String contentType, Folder folder, String filename) throws UserServletException, ServiceException, IOException, ServletException {
        String cs;
        boolean continueOnError = context.ignoreAndContinueOnError();
        boolean preserveExistingAlarms = context.preserveAlarms();
        InputStream is = context.getRequestInputStream(Long.MAX_VALUE);
        String charset = "utf-8";
        String ctStr = context.req.getContentType();
        if (ctStr != null && (cs = Mime.getCharset(ctStr)) != null) {
            charset = cs;
        }
        try {
            if (context.req.getContentLength() <= LC.calendar_ics_import_full_parse_max_size.intValue()) {
                List<ZCalendar.ZVCalendar> icals = ZCalendar.ZCalendarBuilder.buildMulti(is, charset);
                IcsImportParseHandler.ImportInviteVisitor visitor = new IcsImportParseHandler.ImportInviteVisitor(context.opContext, folder, preserveExistingAlarms);
                Invite.createFromCalendar(context.targetAccount, null, icals, true, continueOnError, visitor);
            } else {
                IcsImportParseHandler handler = new IcsImportParseHandler(context.opContext, context.targetAccount, folder, continueOnError, preserveExistingAlarms);
                ZCalendar.ZCalendarBuilder.parse(is, charset, handler);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }
}

