/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.httpclient.Header;

public class HtmlFormatter
extends Formatter {
    private static final String PATH_MAIN_CONTEXT = "/zimbra";
    private static final String PATH_JSP_REST_PAGE = "/h/rest";
    private static final long AUTH_EXPIRATION = 3600000L;
    private static final String ATTR_REQUEST_URI = "zimbra_request_uri";
    private static final String ATTR_INTERNAL_DISPATCH = "zimbra_internal_dispatch";
    private static final String ATTR_AUTH_TOKEN = "zimbra_authToken";
    private static final String ATTR_TARGET_ACCOUNT_NAME = "zimbra_target_account_name";
    private static final String ATTR_TARGET_ACCOUNT_ID = "zimbra_target_account_id";
    private static final String ATTR_TARGET_ITEM_ID = "zimbra_target_item_id";
    private static final String ATTR_TARGET_ITEM_TYPE = "zimbra_target_item_type";
    private static final String ATTR_TARGET_ITEM_COLOR = "zimbra_target_item_color";
    private static final String ATTR_TARGET_ITEM_VIEW = "zimbra_target_item_view";
    private static final String ATTR_TARGET_ITEM_PATH = "zimbra_target_item_path";
    private static final String ATTR_TARGET_ITEM_NAME = "zimbra_target_item_name";
    private static final String ATTR_TARGET_ACCOUNT_PREF_TIME_ZONE = "zimbra_target_account_prefTimeZoneId";
    private static final String ATTR_TARGET_ACCOUNT_PREF_SKIN = "zimbra_target_account_prefSkin";
    private static final String ATTR_TARGET_ACCOUNT_PREF_CALENDAR_FIRST_DAY_OF_WEEK = "zimbra_target_account_prefCalendarFirstDayOfWeek";
    private static final String ATTR_TARGET_ACCOUNT_PREF_CALENDAR_DAY_HOUR_START = "zimbra_target_account_prefCalendarDayHourStart";
    private static final String ATTR_TARGET_ACCOUNT_PREF_CALENDAR_DAY_HOUR_END = "zimbra_target_account_prefCalendarDayHourEnd";

    public boolean canBeBlocked() {
        return false;
    }

    public void formatCallback(UserServlet.Context context) throws UserServletException, ServiceException, IOException, ServletException {
        HtmlFormatter.dispatchJspRest(context.getServlet(), context);
    }

    public String getType() {
        return "html";
    }

    static void dispatchJspRest(Servlet servlet, UserServlet.Context context) throws ServiceException, ServletException, IOException {
        Account acc;
        AuthToken auth = null;
        long expiration = System.currentTimeMillis() + 3600000L;
        auth = context.basicAuthHappened ? ((acc = context.authAccount) instanceof ACL.GuestAccount ? AuthToken.getAuthToken(acc.getId(), acc.getName(), null, ((ACL.GuestAccount)acc).getDigest(), expiration) : AuthProvider.getAuthToken(context.authAccount, expiration)) : (context.cookieAuthHappened ? UserServlet.getAuthTokenFromCookie(context.req, context.resp, true) : AuthToken.getAuthToken("99999999-9999-9999-9999-999999999999", null, null, null, expiration));
        String authString = null;
        try {
            if (auth != null) {
                authString = auth.getEncoded();
            }
        }
        catch (AuthTokenException e) {
            throw new ServletException("error generating the authToken", (Throwable)e);
        }
        Account targetAccount = context.targetAccount;
        MailItem targetItem = context.target;
        String uri = (String)context.req.getAttribute("requestedPath");
        if (targetItem instanceof Mountpoint && ((Mountpoint)targetItem).getDefaultView() != 11) {
            Mountpoint mp = (Mountpoint)targetItem;
            Provisioning prov = Provisioning.getInstance();
            targetAccount = prov.getAccountById(mp.getOwnerId());
            Pair<Header[], UserServlet.HttpInputStream> remoteItem = UserServlet.getRemoteResourceAsStream(auth == null ? null : auth.toZAuthToken(), mp.getTarget(), context.extraPath);
            remoteItem.getSecond().close();
            String remoteItemId = null;
            String remoteItemType = null;
            String remoteItemName = null;
            String remoteItemPath = null;
            for (Header h : remoteItem.getFirst()) {
                if (h.getName().compareToIgnoreCase("X-Zimbra-ItemId") == 0) {
                    remoteItemId = h.getValue();
                    continue;
                }
                if (h.getName().compareToIgnoreCase("X-Zimbra-ItemType") == 0) {
                    remoteItemType = h.getValue();
                    continue;
                }
                if (h.getName().compareToIgnoreCase("X-Zimbra-ItemName") == 0) {
                    remoteItemName = h.getValue();
                    continue;
                }
                if (h.getName().compareToIgnoreCase("X-Zimbra-ItemPath") != 0) continue;
                remoteItemPath = h.getValue();
            }
            context.req.setAttribute(ATTR_TARGET_ITEM_ID, remoteItemId);
            context.req.setAttribute(ATTR_TARGET_ITEM_TYPE, remoteItemType);
            context.req.setAttribute(ATTR_TARGET_ITEM_NAME, remoteItemName);
            context.req.setAttribute(ATTR_TARGET_ITEM_PATH, remoteItemPath);
            context.req.setAttribute(ATTR_TARGET_ITEM_COLOR, (Object)mp.getColor());
            context.req.setAttribute(ATTR_TARGET_ITEM_VIEW, (Object)MailItem.getNameForType(mp.getDefaultView()));
            targetItem = null;
        }
        context.req.setAttribute(ATTR_INTERNAL_DISPATCH, (Object)"yes");
        context.req.setAttribute(ATTR_REQUEST_URI, (Object)(uri != null ? uri : context.req.getRequestURI()));
        context.req.setAttribute(ATTR_AUTH_TOKEN, (Object)authString);
        if (targetAccount != null) {
            context.req.setAttribute(ATTR_TARGET_ACCOUNT_NAME, (Object)targetAccount.getName());
            context.req.setAttribute(ATTR_TARGET_ACCOUNT_ID, (Object)targetAccount.getId());
            context.req.setAttribute(ATTR_TARGET_ACCOUNT_PREF_TIME_ZONE, (Object)targetAccount.getAttr("zimbraPrefTimeZoneId"));
            context.req.setAttribute(ATTR_TARGET_ACCOUNT_PREF_SKIN, (Object)targetAccount.getAttr("zimbraPrefSkin"));
            context.req.setAttribute(ATTR_TARGET_ACCOUNT_PREF_CALENDAR_FIRST_DAY_OF_WEEK, (Object)targetAccount.getAttr("zimbraPrefCalendarFirstDayOfWeek"));
            context.req.setAttribute(ATTR_TARGET_ACCOUNT_PREF_CALENDAR_DAY_HOUR_START, (Object)targetAccount.getAttr("zimbraPrefCalendarDayHourStart"));
            context.req.setAttribute(ATTR_TARGET_ACCOUNT_PREF_CALENDAR_DAY_HOUR_END, (Object)targetAccount.getAttr("zimbraPrefCalendarDayHourEnd"));
        }
        if (targetItem != null) {
            context.req.setAttribute(ATTR_TARGET_ITEM_ID, (Object)targetItem.getId());
            context.req.setAttribute(ATTR_TARGET_ITEM_TYPE, (Object)MailItem.getNameForType(targetItem));
            context.req.setAttribute(ATTR_TARGET_ITEM_PATH, (Object)targetItem.getPath());
            context.req.setAttribute(ATTR_TARGET_ITEM_NAME, (Object)targetItem.getName());
            context.req.setAttribute(ATTR_TARGET_ITEM_COLOR, (Object)targetItem.getColor());
            if (targetItem instanceof Folder) {
                context.req.setAttribute(ATTR_TARGET_ITEM_VIEW, (Object)MailItem.getNameForType(((Folder)targetItem).getDefaultView()));
            }
        }
        String mailUrl = PATH_MAIN_CONTEXT;
        try {
            mailUrl = Provisioning.getInstance().getLocalServer().getMailURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        ServletContext targetContext = servlet.getServletConfig().getServletContext().getContext(mailUrl);
        RequestDispatcher dispatcher = targetContext.getRequestDispatcher(PATH_JSP_REST_PAGE);
        dispatcher.forward((ServletRequest)context.req, (ServletResponse)context.resp);
    }
}

