/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.util.ByteUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class HeadersOnlyInputStream
extends InputStream {
    private InputStream mIn;
    private boolean mEOF = false;

    public HeadersOnlyInputStream(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        this.mIn = in;
    }

    public int read() throws IOException {
        if (this.mEOF) {
            return -1;
        }
        int c = this.mIn.read();
        if (c == 13) {
            this.mIn.mark(4);
            if (this.mIn.read() != 10 || this.mIn.read() != 13 || this.mIn.read() != 10) {
                this.mIn.reset();
            } else {
                this.mEOF = true;
                return -1;
            }
        }
        return c;
    }

    public void close() throws IOException {
        this.mIn.close();
    }

    public synchronized void mark(int readlimit) {
        this.mIn.mark(readlimit);
    }

    public boolean markSupported() {
        return this.mIn.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.mIn.reset();
    }

    public static byte[] getHeaders(InputStream is) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(1024);
        ByteUtil.copy(new HeadersOnlyInputStream(is), true, buf, false);
        return buf.toByteArray();
    }
}

