/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;

public class FormatterServiceException
extends ServiceException {
    public static final String INVALID_FORMAT = "formatter.INVALID_FORMAT";
    public static final String INVALID_TYPE = "formatter.INVALID_TYPE";
    public static final String MISMATCHED_META = "formatter.MISMATCHED_META";
    public static final String MISMATCHED_SIZE = "formatter.MISMATCHED_SIZE";
    public static final String MISMATCHED_TYPE = "formatter.MISMATCHED_TYPE";
    public static final String MISSING_BLOB = "formatter.MISSING_BLOB";
    public static final String MISSING_META = "formatter.MISSING_META";
    public static final String MISSING_VCARD_FIELDS = "formatter.MISSING_VCARD_FIELDS";
    public static final String UNKNOWN_ERROR = "formatter.UNKNOWN_ERROR";
    public static final String FILE_NAME = "filename";
    public static final String ITEM_PATH = "path";
    public static final String ITEM_TYPE = "view";

    FormatterServiceException(String message, String code, boolean isReceiversFault, ServiceException.Argument ... args) {
        super(message, code, isReceiversFault, args);
    }

    FormatterServiceException(String message, String code, boolean isReceiversFault, Throwable cause, ServiceException.Argument ... args) {
        super(message, code, isReceiversFault, cause, args);
    }

    public static FormatterServiceException INVALID_FORMAT(String filename) {
        return new FormatterServiceException("invalid file format", INVALID_FORMAT, false, FormatterServiceException.arg(FILE_NAME, filename));
    }

    public static FormatterServiceException INVALID_TYPE(String view, String path) {
        return new FormatterServiceException("folder cannot contain item type " + view, INVALID_TYPE, false, FormatterServiceException.arg(ITEM_TYPE, view), FormatterServiceException.arg(ITEM_PATH, path));
    }

    public static FormatterServiceException MISMATCHED_META(String path) {
        return new FormatterServiceException("mismatched item content and meta", MISMATCHED_META, false, FormatterServiceException.arg(ITEM_PATH, path));
    }

    public static FormatterServiceException MISMATCHED_SIZE(String path) {
        return new FormatterServiceException("ignored item data size mismatch", MISMATCHED_SIZE, false, FormatterServiceException.arg(ITEM_PATH, path));
    }

    public static FormatterServiceException MISMATCHED_TYPE(String path) {
        return new FormatterServiceException("cannot overwrite non matching data", MISMATCHED_TYPE, false, FormatterServiceException.arg(ITEM_PATH, path));
    }

    public static FormatterServiceException MISSING_BLOB(String path) {
        return new FormatterServiceException("missing item blob for meta", MISSING_BLOB, false, FormatterServiceException.arg(ITEM_PATH, path));
    }

    public static FormatterServiceException MISSING_META(String path) {
        return new FormatterServiceException("item content missing meta information", MISSING_META, false, FormatterServiceException.arg(ITEM_PATH, path));
    }

    public static FormatterServiceException MISSING_VCARD_FIELDS(String path) {
        return new FormatterServiceException("no contact fields found in vcard", MISSING_VCARD_FIELDS, false, FormatterServiceException.arg(ITEM_PATH, path));
    }

    public static FormatterServiceException UNKNOWN_ERROR(Throwable cause) {
        if (cause instanceof ServiceException) {
            return FormatterServiceException.WRAPPED_EXCEPTION((ServiceException)cause);
        }
        return new FormatterServiceException(cause.getMessage() == null ? cause.toString() : cause.getMessage(), UNKNOWN_ERROR, true, cause, new ServiceException.Argument[0]);
    }

    public static FormatterServiceException UNKNOWN_ERROR(String path, Throwable cause) {
        if (cause instanceof ServiceException) {
            return FormatterServiceException.WRAPPED_EXCEPTION((ServiceException)cause);
        }
        return new FormatterServiceException(cause.getMessage() == null ? cause.toString() : cause.getMessage(), UNKNOWN_ERROR, true, cause, FormatterServiceException.arg(ITEM_PATH, path));
    }

    private static FormatterServiceException WRAPPED_EXCEPTION(ServiceException e) {
        return new FormatterServiceException(e.getMessage(), e.getCode(), e.isReceiversFault(), e.getCause(), e.getArgs());
    }

    private static ServiceException.Argument arg(String name, String value) {
        return new ServiceException.Argument(name, value, ServiceException.Argument.Type.STR);
    }
}

