/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.operation.BlockingOperation;
import com.zimbra.cs.operation.Requester;
import com.zimbra.cs.operation.Scheduler;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.FormatterServiceException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Formatter {
    private static String PROGRESS = "-progress";

    public abstract String getType();

    public String[] getDefaultMimeTypes() {
        return new String[0];
    }

    public boolean requiresAuth() {
        return true;
    }

    public abstract boolean canBeBlocked();

    public long getDefaultStartTime() {
        return -1L;
    }

    public long getDefaultEndTime() {
        return -1L;
    }

    public String getDefaultSearchTypes() {
        return "message";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void format(UserServlet.Context context) throws UserServletException, IOException, ServletException, ServiceException {
        BlockingOperation op = BlockingOperation.schedule(this.getClass().getSimpleName() + "(FORMAT)", null, context.opContext, context.targetMailbox, Requester.REST, Scheduler.Priority.BATCH, 1);
        try {
            try {
                this.formatCallback(context);
                this.updateClient(context, null);
            }
            catch (Exception e) {
                this.updateClient(context, e);
                Object var5_4 = null;
                op.finish();
            }
            Object var5_3 = null;
            op.finish();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            op.finish();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(UserServlet.Context context, String contentType, Folder folder, String filename) throws UserServletException, IOException, ServletException, ServiceException {
        BlockingOperation op = BlockingOperation.schedule(this.getClass().getSimpleName() + "(SAVE)", null, context.opContext, context.targetMailbox, Requester.REST, Scheduler.Priority.BATCH, 1);
        Mailbox mbox = context.targetMailbox;
        try {
            try {
                mbox.setIndexImmediatelyMode();
                this.saveCallback(context, contentType, folder, filename);
                this.updateClient(context, null);
            }
            catch (Exception e) {
                this.updateClient(context, e);
                Object var9_8 = null;
                mbox.clearIndexImmediatelyMode();
                op.finish();
            }
            Object var9_7 = null;
            mbox.clearIndexImmediatelyMode();
            op.finish();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            mbox.clearIndexImmediatelyMode();
            op.finish();
            throw throwable;
        }
    }

    public abstract void formatCallback(UserServlet.Context var1) throws UserServletException, ServiceException, IOException, ServletException;

    public void saveCallback(UserServlet.Context context, String contentType, Folder folder, String filename) throws UserServletException, ServiceException, IOException, ServletException {
        throw new UserServletException(400, "format not supported for save");
    }

    public boolean supportsSave() {
        return false;
    }

    public Iterator<? extends MailItem> getMailItems(UserServlet.Context context, long startTime, long endTime, long chunkSize) throws ServiceException {
        if (context.respListItems != null) {
            return context.respListItems.iterator();
        }
        assert (context.target != null);
        String query = context.getQueryString();
        if (query != null) {
            try {
                String searchTypes;
                Folder f;
                if (context.target instanceof Folder && (f = (Folder)context.target).getId() != 1) {
                    query = "in:" + f.getPath() + " " + query;
                }
                if ((searchTypes = context.getTypesString()) == null) {
                    searchTypes = this.getDefaultSearchTypes();
                }
                byte[] types = MailboxIndex.parseTypesString(searchTypes);
                ZimbraQueryResults results = context.targetMailbox.search(context.opContext, query, types, SortBy.DATE_DESCENDING, context.getOffset() + context.getLimit());
                return new QueryResultIterator(results);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("search error", e);
            }
            catch (ParseException e) {
                throw ServiceException.FAILURE("search error", e);
            }
        }
        if (context.target instanceof Folder) {
            Collection<? extends MailItem> items = this.getMailItemsFromFolder(context, (Folder)context.target, startTime, endTime, chunkSize);
            return items != null ? items.iterator() : null;
        }
        ArrayList<MailItem> result = new ArrayList<MailItem>();
        result.add(context.target);
        return result.iterator();
    }

    private Collection<? extends MailItem> getMailItemsFromFolder(UserServlet.Context context, Folder folder, long startTime, long endTime, long chunkSize) throws ServiceException {
        switch (folder.getDefaultView()) {
            case 11: 
            case 15: {
                return context.targetMailbox.getCalendarItemsForRange(context.opContext, startTime, endTime, folder.getId(), null);
            }
            case 6: {
                return context.targetMailbox.getContactList(context.opContext, folder.getId(), SortBy.NAME_ASCENDING);
            }
            case 8: 
            case 14: {
                return context.targetMailbox.getDocumentList(context.opContext, folder.getId(), SortBy.NAME_ASCENDING);
            }
        }
        return context.targetMailbox.getItemList(context.opContext, (byte)5, folder.getId());
    }

    public static boolean checkGlobalOverride(String attr, Account account) throws ServletException {
        Provisioning prov = Provisioning.getInstance();
        try {
            return prov.getConfig().getBooleanAttr(attr, false) || account.getBooleanAttr(attr, false);
        }
        catch (ServiceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected PrintWriter updateClient(UserServlet.Context context, boolean flush) throws IOException {
        PrintWriter pw;
        if (context.params.get(PROGRESS) == null) {
            context.resp.reset();
            context.resp.setContentType("text/html; charset=\"utf-8\"");
            context.resp.setCharacterEncoding("utf-8");
            context.params.put(PROGRESS, "1");
            pw = context.resp.getWriter();
            pw.print("<html>\n<head>\n</head>\n");
        } else {
            pw = context.resp.getWriter();
            pw.println();
        }
        if (flush) {
            pw.flush();
        }
        return pw;
    }

    protected void updateClient(UserServlet.Context context, Exception e) throws UserServletException, IOException, ServletException, ServiceException {
        this.updateClient(context, e, null);
    }

    protected void updateClient(UserServlet.Context context, Exception e, List<ServiceException> w) throws UserServletException, IOException, ServletException, ServiceException {
        String callback = context.params.get("callback");
        Throwable exception = null;
        ServiceException se = null;
        if (e != null) {
            Throwable cause = e.getCause();
            Throwable throwable = exception = cause instanceof UserServletException || cause instanceof ServletException || cause instanceof IOException ? cause : e;
        }
        if (exception != null) {
            ServiceException serviceException = se = exception instanceof ServiceException ? (ServiceException)exception : FormatterServiceException.UNKNOWN_ERROR(exception);
        }
        if (callback == null || callback.equals("")) {
            if (context.params.get(PROGRESS) == null) {
                if (exception == null) {
                    return;
                }
                if (exception instanceof UserServletException) {
                    throw (UserServletException)exception;
                }
                if (exception instanceof ServletException) {
                    throw (ServletException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw ServiceException.FAILURE(this.getType() + " formatter failure", exception);
            }
            PrintWriter out = this.updateClient(context, false);
            if (exception == null && w == null) {
                out.println("<body></body>\n</html>");
            } else {
                ZimbraLog.misc.warn((Object)(this.getType() + " formatter exception"), exception);
                out.println("<body>\n<pre>");
                if (exception != null) {
                    out.print(exception.getLocalizedMessage());
                }
                for (ServiceException warning : w) {
                    out.println("<br>");
                    out.println(warning.toString().replace("\n", "<br>"));
                }
                out.println("</pre>\n</body>\n</html>");
            }
        } else if (!"2".equals(context.params.get(PROGRESS))) {
            PrintWriter out = this.updateClient(context, false);
            context.params.put(PROGRESS, "2");
            out.println("<body onload='onLoad()'>");
            out.println("<script>");
            out.println("function onLoad() {");
            if (exception == null && w == null) {
                out.print("    window.parent." + callback + "('success');");
            } else {
                String result = exception != null ? "fail" : "warn";
                out.print("    window.parent." + callback + "('" + result + "'");
                if (exception != null) {
                    out.print(",\n\t");
                    out.print(SoapProtocol.SoapJS.soapFault(se));
                }
                if (w != null) {
                    for (ServiceException warning : w) {
                        out.print(",\n\t");
                        out.print(SoapProtocol.SoapJS.soapFault(warning));
                    }
                }
                out.println(");");
            }
            out.println("}");
            out.println("</script>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class QueryResultIterator
    implements Iterator<MailItem> {
        private ZimbraQueryResults mResults;

        QueryResultIterator(ZimbraQueryResults results) {
            this.mResults = results;
        }

        @Override
        public boolean hasNext() {
            if (this.mResults == null) {
                return false;
            }
            try {
                return this.mResults.hasNext();
            }
            catch (ServiceException e) {
                ZimbraLog.misc.warn((Object)"caught exception", e);
                return false;
            }
        }

        @Override
        public MailItem next() {
            if (this.mResults == null) {
                return null;
            }
            try {
                ZimbraHit hit = this.mResults.getNext();
                if (hit != null) {
                    return hit.getMailItem();
                }
            }
            catch (ServiceException e) {
                ZimbraLog.misc.warn((Object)"caught exception", e);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void finished() {
            try {
                if (this.mResults != null) {
                    this.mResults.doneWithSearchResults();
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            this.mResults = null;
        }
    }
}

