/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.ContactCSV;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.service.mail.ImportContacts;
import com.zimbra.cs.service.util.ItemId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CsvFormatter
extends Formatter {
    public String getType() {
        return "csv";
    }

    public String[] getDefaultMimeTypes() {
        return new String[]{"text/csv", "text/comma-separated-values", "text/plain"};
    }

    public String getDefaultSearchTypes() {
        return "contact";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException {
        String filename;
        Iterator<? extends MailItem> iterator = null;
        StringBuffer sb = new StringBuffer();
        try {
            try {
                iterator = this.getMailItems(context, -1L, -1L, Integer.MAX_VALUE);
                String format = context.req.getParameter("csvfmt");
                ContactCSV.toCSV(format, iterator, sb);
            }
            catch (ContactCSV.ParseException e) {
                throw MailServiceException.UNABLE_TO_IMPORT_CONTACTS("could not generate CSV", e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (iterator instanceof Formatter.QueryResultIterator) {
                ((Formatter.QueryResultIterator)iterator).finished();
            }
            throw throwable;
        }
        if (iterator instanceof Formatter.QueryResultIterator) {
            ((Formatter.QueryResultIterator)iterator).finished();
        }
        if ((filename = context.itemPath) == null || filename.length() == 0) {
            filename = "contacts";
        }
        String cd = "attachment; filename=" + HttpUtil.encodeFilename(context.req, filename + ".csv");
        context.resp.addHeader("Content-Disposition", cd);
        context.resp.setCharacterEncoding("utf-8");
        context.resp.setContentType("text/csv");
        context.resp.getWriter().print(sb.toString());
    }

    public boolean canBeBlocked() {
        return false;
    }

    public boolean supportsSave() {
        return true;
    }

    public void saveCallback(UserServlet.Context context, String contentType, Folder folder, String filename) throws UserServletException, ServiceException, IOException {
        InputStreamReader isr = new InputStreamReader(context.getRequestInputStream(), "utf-8");
        BufferedReader reader = new BufferedReader(isr);
        try {
            try {
                String format = context.params.get("csvfmt");
                List<Map<String, String>> contacts = ContactCSV.getContacts(reader, format);
                ItemId iidFolder = new ItemId(folder);
                ImportContacts.ImportCsvContacts(context.opContext, context.targetMailbox, iidFolder, contacts);
            }
            catch (ContactCSV.ParseException e) {
                throw new UserServletException(400, "could not parse csv file");
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }
}

