/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.service.util.ItemIdFormatter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;

public class ContactFolderFormatter
extends Formatter {
    private static final byte FIELD_DELIMITER = 29;
    private static final byte CONTACT_DELIMITER = 30;
    private static final String CONTENT_TYPE = "text/x-zimbra-delimitted-fields";

    public boolean canBeBlocked() {
        return false;
    }

    public void formatCallback(UserServlet.Context context) throws UserServletException, ServiceException, IOException, ServletException {
        if (!(context.target instanceof Folder)) {
            throw UserServletException.notImplemented("can only handle Folders");
        }
        Folder f = (Folder)context.target;
        if (f.getDefaultView() != 6) {
            throw UserServletException.notImplemented("can only handle Contact Folders");
        }
        String v = context.params.get("t");
        Delimiter d = Delimiter.Field;
        if (v != null && v.equals("2")) {
            d = Delimiter.Contact;
        }
        ItemIdFormatter ifmt = new ItemIdFormatter(context.authAccount, context.targetAccount, false);
        context.resp.setContentType(CONTENT_TYPE);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)context.resp.getOutputStream());
        Iterator<? extends MailItem> contacts = this.getMailItems(context, 0L, 0L, 0L);
        while (contacts.hasNext()) {
            MailItem item = contacts.next();
            if (!(item instanceof Contact)) continue;
            ((OutputStream)out).write("id".getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            ((OutputStream)out).write(ifmt.formatItemId(item).getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            ((OutputStream)out).write("l".getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            ((OutputStream)out).write(ifmt.formatItemId(item.getFolderId()).getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            ((OutputStream)out).write("d".getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            ((OutputStream)out).write(Long.toString(item.getDate()).getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            ((OutputStream)out).write("rev".getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            ((OutputStream)out).write(Integer.toString(item.getSavedSequence()).getBytes("UTF-8"));
            ((OutputStream)out).write(29);
            try {
                String fileAsStr = ((Contact)item).getFileAsString();
                ((OutputStream)out).write("fileAsStr".getBytes("UTF-8"));
                ((OutputStream)out).write(29);
                ((OutputStream)out).write(fileAsStr.getBytes("UTF-8"));
            }
            catch (ServiceException se) {
                // empty catch block
            }
            Map<String, String> fields = ((Contact)item).getFields();
            for (String k : fields.keySet()) {
                ((OutputStream)out).write(29);
                ((OutputStream)out).write(k.getBytes("UTF-8"));
                ((OutputStream)out).write(29);
                ((OutputStream)out).write(fields.get(k).getBytes("UTF-8"));
            }
            switch (d) {
                case Field: {
                    ((OutputStream)out).write(29);
                    break;
                }
                case Contact: {
                    ((OutputStream)out).write(30);
                }
            }
        }
        ((OutputStream)out).flush();
    }

    public String getType() {
        return "cf";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Delimiter {
        Field,
        Contact;

    }
}

