/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Tag;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactCSV {
    private HashMap<String, Integer> mFieldCols;
    private ArrayList<String> mFields;
    private static final String TAG = "__tag";
    private static final QName FIELDS = QName.get("fields");
    private static final QName FIELD = QName.get("field");
    private static final QName FORMAT = QName.get("format");
    private static final QName COLUMN = QName.get("column");
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FIELD = "field";
    private static final String ATTR_FLAG = "flag";
    private static final String ATTR_TYPE = "type";
    private static Set<String> mKnownFields;
    private static Set<CsvFormat> mKnownFormats;
    private static CsvFormat mDefaultFormat;

    private boolean parseLine(BufferedReader reader, List<String> result, boolean parsingHeader) throws IOException, ParseException {
        int ch;
        result.clear();
        boolean inField = false;
        block6: while ((ch = reader.read()) != -1) {
            switch (ch) {
                case 34: {
                    inField = true;
                    result.add(this.parseField(reader, true, -1, parsingHeader, result.size()));
                    continue block6;
                }
                case 44: {
                    if (inField) {
                        inField = false;
                        continue block6;
                    }
                    result.add(null);
                    continue block6;
                }
                case 10: {
                    if (result.size() <= 0) continue block6;
                    return true;
                }
                case 13: {
                    reader.mark(1);
                    ch = reader.read();
                    if (ch != 10) {
                        reader.reset();
                    }
                    if (result.size() <= 0) continue block6;
                    return true;
                }
            }
            result.add(this.parseField(reader, false, ch, parsingHeader, result.size()));
            inField = false;
        }
        return result.size() > 0;
    }

    private String parseField(BufferedReader reader, boolean doubleQuotes, int firstChar, boolean parsingHeader, int size) throws IOException, ParseException {
        int ch;
        StringBuffer sb = new StringBuffer();
        if (firstChar != -1) {
            sb.append((char)firstChar);
        }
        reader.mark(1);
        while ((ch = reader.read()) != -1) {
            if (ch == 34 && doubleQuotes) {
                reader.mark(1);
                ch = reader.read();
                if (ch != 34) {
                    reader.reset();
                    if (sb.length() == 0) {
                        return null;
                    }
                    return sb.toString();
                }
                sb.append((char)ch);
            } else {
                if (ch == 44 && !doubleQuotes) {
                    return sb.toString();
                }
                if (!(ch != 13 && ch != 10 || doubleQuotes)) {
                    reader.reset();
                    return sb.toString();
                }
                sb.append((char)ch);
            }
            reader.mark(1);
        }
        if (doubleQuotes) {
            throw new ParseException("end of stream reached while parsing field");
        }
        return sb.toString();
    }

    private void initFields(BufferedReader reader, String fmt) throws IOException, ParseException {
        this.mFields = new ArrayList();
        if (!this.parseLine(reader, this.mFields, true)) {
            throw new ParseException("no column name definitions");
        }
        this.mFieldCols = new HashMap(this.mFields.size());
        for (int i = 0; i < this.mFields.size(); ++i) {
            String fieldName = this.mFields.get(i);
            if (fieldName == null || fieldName.equals("")) {
                throw new ParseException("missing column name for column " + i);
            }
            this.mFieldCols.put(fieldName.toLowerCase(), i);
        }
    }

    private String getField(String colName, List<String> csv) {
        Integer col = this.mFieldCols.get(colName.toLowerCase());
        if (col == null || col >= csv.size()) {
            return null;
        }
        return csv.get(col);
    }

    private void addField(String colName, List<String> csv, String field, Map<String, String> contact) {
        String value = this.getField(colName.toLowerCase(), csv);
        if (field != null && value != null && value.length() > 0) {
            contact.put(field, value);
        }
    }

    private void addMultiValueField(List<String> names, List<String> csv, String field, Map<String, String> contact) {
        StringBuilder buf = new StringBuilder();
        for (String n : names) {
            String v = this.getField(n.toLowerCase(), csv);
            if (v == null) continue;
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(v);
        }
        if (buf.length() > 0) {
            contact.put(field, buf.toString());
        }
    }

    private void addNameField(String colName, List<String> csv, String field, Map<String, String> contact) {
        int anotherSpace;
        String value = this.getField(colName.toLowerCase(), csv);
        if (field == null || value == null) {
            return;
        }
        String[] nameFields = field.split(",");
        String firstNameField = nameFields[0];
        if (firstNameField == null) {
            return;
        }
        String middleNameField = null;
        String lastNameField = null;
        if (nameFields.length == 2) {
            lastNameField = nameFields[1];
        } else if (nameFields.length == 3) {
            middleNameField = nameFields[1];
            lastNameField = nameFields[2];
        } else {
            contact.put(firstNameField, value);
            return;
        }
        int comma = value.indexOf(44);
        if (comma > 0) {
            contact.put(lastNameField, value.substring(0, comma).trim());
            contact.put(firstNameField, value.substring(comma + 1).trim());
            return;
        }
        int space = value.indexOf(32);
        if (space == -1) {
            contact.put(firstNameField, value);
            return;
        }
        contact.put(firstNameField, value.substring(0, space).trim());
        if (middleNameField != null && (anotherSpace = value.indexOf(32, ++space)) > 0) {
            contact.put(middleNameField, value.substring(space, anotherSpace).trim());
            space = anotherSpace + 1;
        }
        if (space < value.length()) {
            contact.put(lastNameField, value.substring(space).trim());
        }
    }

    public static String getTags(Map<String, String> csv) {
        return csv.remove(TAG);
    }

    private Map<String, String> toContact(List<String> csv, CsvFormat format) throws ParseException {
        HashMap<String, String> contact = new HashMap<String, String>();
        if (format.allFields()) {
            for (String field : this.mFields) {
                this.addField(field, csv, field, contact);
            }
        } else if (format.hasNoHeaders()) {
            int end = csv.size();
            end = end > format.columns.size() ? format.columns.size() : end;
            for (int i = 0; i < end; ++i) {
                String key = format.columns.get((int)i).field;
                String val = csv.get(i);
                if (key == null || val == null) continue;
                contact.put(key, val);
            }
        } else {
            for (CsvColumn col : format.columns) {
                if (col.multivalue) {
                    this.addMultiValueField(col.names, csv, col.field, contact);
                    continue;
                }
                if (col.isName) {
                    this.addNameField(col.name, csv, col.field, contact);
                    continue;
                }
                if (col.mapToTag) {
                    String tag = this.getField(col.name, csv);
                    if (tag == null) continue;
                    contact.put(TAG, tag);
                    continue;
                }
                this.addField(col.name, csv, col.field, contact);
            }
        }
        return contact;
    }

    private List<Map<String, String>> getContactsInternal(BufferedReader reader, String fmt) throws ParseException {
        try {
            CsvFormat format = null;
            this.initFields(reader, fmt);
            format = fmt == null ? ContactCSV.guessFormat(this.mFields) : ContactCSV.getFormat(fmt);
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            ArrayList<String> fields = new ArrayList<String>();
            while (this.parseLine(reader, fields, false)) {
                Map<String, String> contact = this.toContact(fields, format);
                if (contact.size() <= 0) continue;
                result.add(contact);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage(), ioe);
        }
    }

    public static List<Map<String, String>> getContacts(BufferedReader reader, String fmt) throws ParseException {
        ContactCSV csv = new ContactCSV();
        return csv.getContactsInternal(reader, fmt);
    }

    private static void populateFields(Element fields) {
        mKnownFields = new HashSet<String>();
        Iterator elements = fields.elementIterator(FIELD);
        while (elements.hasNext()) {
            Element field = (Element)elements.next();
            mKnownFields.add(field.attributeValue(ATTR_NAME));
        }
    }

    private static void addFormat(Element format) {
        CsvFormat fmt = new CsvFormat(format);
        Iterator elements = format.elementIterator(COLUMN);
        while (elements.hasNext()) {
            Element col = (Element)elements.next();
            fmt.add(col);
        }
        if (mKnownFormats == null) {
            mKnownFormats = new HashSet<CsvFormat>();
        }
        mKnownFormats.add(fmt);
        if (fmt.hasFlag("default")) {
            mDefaultFormat = fmt;
        }
    }

    private static void readMappingFile(String mappingFile) throws IOException, DocumentException {
        ContactCSV.readMapping(new FileInputStream(mappingFile));
    }

    private static void readMapping(InputStream is) throws IOException, DocumentException {
        Element root = com.zimbra.common.soap.Element.getSAXReader().read(is).getRootElement();
        Iterator elements = root.elementIterator();
        while (elements.hasNext()) {
            Element elem = (Element)elements.next();
            if (elem.getQName().equals(FIELDS)) {
                ContactCSV.populateFields(elem);
                continue;
            }
            if (!elem.getQName().equals(FORMAT)) continue;
            ContactCSV.addFormat(elem);
        }
    }

    private static CsvFormat guessFormat(List<String> keys) throws ParseException {
        if (mKnownFormats == null || mDefaultFormat == null) {
            throw new ParseException("missing config file " + LC.zimbra_csv_mapping_file.value());
        }
        int numBestMatch = 0;
        CsvFormat bestMatch = mDefaultFormat;
        for (CsvFormat f : mKnownFormats) {
            int numMatchedFields = 0;
            for (CsvColumn col : f.columns) {
                if (!keys.contains(col.name)) continue;
                ++numMatchedFields;
            }
            if (numMatchedFields <= numBestMatch) continue;
            numBestMatch = numMatchedFields;
            bestMatch = f;
        }
        return bestMatch;
    }

    private static CsvFormat getFormat(String fmt) throws ParseException {
        if (mKnownFormats == null || mDefaultFormat == null) {
            throw new ParseException("missing config file " + LC.zimbra_csv_mapping_file.value());
        }
        for (CsvFormat f : mKnownFormats) {
            if (!f.name.equals(fmt)) continue;
            return f;
        }
        return mDefaultFormat;
    }

    public static void toCSV(String format, Iterator contacts, StringBuffer sb) throws ParseException {
        if (mKnownFormats == null) {
            return;
        }
        CsvFormat fmt = ContactCSV.getFormat(format);
        if (fmt == null) {
            return;
        }
        if (fmt.allFields()) {
            ArrayList<Map<String, String>> allContacts = new ArrayList<Map<String, String>>();
            HashSet<String> fields = new HashSet<String>();
            while (contacts.hasNext()) {
                Object obj = contacts.next();
                if (!(obj instanceof Contact)) continue;
                Contact c = (Contact)obj;
                allContacts.add(c.getFields());
                fields.addAll(c.getFields().keySet());
            }
            ArrayList<String> allFields = new ArrayList<String>();
            allFields.addAll(fields);
            Collections.sort(allFields);
            ContactCSV.addFieldDef(allFields, sb);
            for (Map map : allContacts) {
                ContactCSV.toCSVContact(allFields, map, sb);
            }
            return;
        }
        if (!fmt.hasNoHeaders()) {
            ContactCSV.addFieldDef(fmt, sb);
        }
        while (contacts.hasNext()) {
            Object c = contacts.next();
            if (!(c instanceof Contact)) continue;
            ContactCSV.toCSVContact(fmt, (Contact)c, sb);
        }
    }

    private static void addFieldValue(Map contact, String name, String field, StringBuffer sb) {
        String value = (String)contact.get(field == null ? name : field);
        if (value == null) {
            value = "";
        }
        sb.append('\"');
        sb.append(value.replaceAll("\"", "\"\""));
        sb.append('\"');
    }

    private static void toCSVContact(List<String> fields, Map contact, StringBuffer sb) {
        boolean first = true;
        for (String f : fields) {
            if (!first) {
                sb.append(',');
            }
            ContactCSV.addFieldValue(contact, f, f, sb);
            first = false;
        }
        sb.append("\n");
    }

    private static void toCSVContact(CsvFormat fmt, Contact c, StringBuffer sb) {
        boolean first = true;
        for (CsvColumn col : fmt.columns) {
            if (!first) {
                sb.append(',');
            }
            if (col.mapToTag) {
                try {
                    boolean firstTag = true;
                    sb.append('\"');
                    for (Tag t : c.getTagList()) {
                        if (!firstTag) {
                            sb.append(',');
                        }
                        sb.append(t.getName());
                        firstTag = false;
                    }
                    sb.append('\"');
                }
                catch (ServiceException se) {}
            } else {
                ContactCSV.addFieldValue(c.getFields(), col.name, col.field, sb);
            }
            first = false;
        }
        sb.append("\n");
    }

    private static void addFieldDef(List<String> fields, StringBuffer sb) {
        boolean first = true;
        for (String f : fields) {
            if (!first) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(f);
            sb.append('\"');
            first = false;
        }
        sb.append("\n");
    }

    private static void addFieldDef(CsvFormat fmt, StringBuffer sb) {
        boolean first = true;
        for (CsvColumn col : fmt.columns) {
            if (!first) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(col.name);
            sb.append('\"');
            first = false;
        }
        sb.append("\n");
    }

    private static void writeLine(OutputStream out, String line) throws IOException {
        out.write(line.getBytes());
        out.write(10);
    }

    private static void dump(OutputStream out) throws IOException {
        ContactCSV.writeLine(out, "=== Fields ===");
        for (String f : mKnownFields) {
            ContactCSV.writeLine(out, f);
        }
        for (CsvFormat fmt : mKnownFormats) {
            ContactCSV.writeLine(out, "=== Mapping " + fmt.name + " (" + fmt.flags + ")" + " ===");
            for (CsvColumn col : fmt.columns) {
                ContactCSV.writeLine(out, col.name + ": " + col.field);
            }
        }
    }

    public static String[] getAllFormatNames() {
        HashSet<String> formats = new HashSet<String>();
        for (CsvFormat f : mKnownFormats) {
            formats.add(f.name);
        }
        return formats.toArray(new String[0]);
    }

    public static void main(String[] args) throws IOException, ParseException, DocumentException {
        ContactCSV.readMappingFile(args[0]);
        ContactCSV.dump(System.out);
    }

    static {
        try {
            ContactCSV.readMappingFile(LC.zimbra_csv_mapping_file.value());
        }
        catch (Exception e) {
            ZimbraLog.misc.error((Object)"error initializing csv mapping file", e);
        }
    }

    private static class CsvFormat {
        String name;
        Set<String> flags;
        List<CsvColumn> columns;
        Map<String, String> forwardMapping;
        Map<String, String> reverseMapping;

        CsvFormat(Element fmt) {
            this.name = fmt.attributeValue(ContactCSV.ATTR_NAME);
            String f = fmt.attributeValue(ContactCSV.ATTR_FLAG);
            this.flags = new HashSet<String>();
            if (f != null) {
                Collections.addAll(this.flags, f.toLowerCase().split(","));
            }
            this.columns = new ArrayList<CsvColumn>();
            this.forwardMapping = new HashMap<String, String>();
            this.reverseMapping = new HashMap<String, String>();
        }

        void add(Element col) {
            CsvColumn newColumn = new CsvColumn(col);
            this.columns.add(newColumn);
            this.forwardMapping.put(newColumn.name, newColumn.field);
            this.reverseMapping.put(newColumn.field, newColumn.name);
        }

        boolean hasFlag(String f) {
            return this.flags.contains(f.toLowerCase());
        }

        boolean hasNoHeaders() {
            return this.hasFlag("noheader");
        }

        boolean allFields() {
            return this.hasFlag("allfields");
        }
    }

    private static class CsvColumn {
        String name;
        String field;
        List<String> names = new ArrayList<String>();
        boolean multivalue;
        boolean isName;
        boolean mapToTag;

        CsvColumn(Element col) {
            this.name = col.attributeValue(ContactCSV.ATTR_NAME);
            this.field = col.attributeValue(ContactCSV.ATTR_FIELD);
            String type = col.attributeValue(ContactCSV.ATTR_TYPE);
            if (type == null) {
                return;
            }
            if (type.equals("multivalue")) {
                this.multivalue = true;
                Collections.addAll(this.names, this.name.split(","));
                this.name = this.names.get(0);
            } else if (type.equals(ContactCSV.ATTR_NAME)) {
                this.isName = true;
            } else if (type.equals("tag")) {
                this.mapToTag = true;
            }
        }
    }

    public static class ParseException
    extends Exception {
        ParseException(String msg) {
            super(msg);
        }

        ParseException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

