/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.DateUtil;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.formatter.Formatter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class AtomFormatter
extends Formatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException {
        Iterator<? extends MailItem> iterator = null;
        StringBuffer sb = new StringBuffer();
        Element.XMLElement feed = new Element.XMLElement("feed");
        int offset = context.getOffset();
        int limit = context.getLimit();
        try {
            iterator = this.getMailItems(context, context.getStartTime(), context.getEndTime(), limit - offset);
            context.resp.setCharacterEncoding("UTF-8");
            context.resp.setContentType("application/atom+xml");
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            feed.addAttribute("xmlns", "http://www.w3.org/2005/Atom");
            feed.addElement("title").setText("Zimbra " + context.itemPath);
            feed.addElement("generator").setText("Zimbra Atom Feed Servlet");
            feed.addElement("id").setText(context.req.getRequestURL().toString());
            feed.addElement("updated").setText(DateUtil.toISO8601(new Date(context.targetMailbox.getLastChangeDate())));
            int curHit = 0;
            while (iterator.hasNext()) {
                MailItem itItem = iterator.next();
                if (++curHit > limit) break;
                if (curHit < offset) continue;
                if (itItem instanceof CalendarItem) {
                    CalendarItem calItem = (CalendarItem)itItem;
                    if (!calItem.isPublic() && !calItem.allowPrivateAccess(context.authAccount, context.isUsingAdminPrivileges())) continue;
                    this.addCalendarItem(calItem, feed, context);
                    continue;
                }
                if (!(itItem instanceof Message)) continue;
                this.addMessage((Message)itItem, feed, context);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (iterator instanceof Formatter.QueryResultIterator) {
                ((Formatter.QueryResultIterator)iterator).finished();
            }
            throw throwable;
        }
        if (iterator instanceof Formatter.QueryResultIterator) {
            ((Formatter.QueryResultIterator)iterator).finished();
        }
        sb.append(feed.toString());
        context.resp.getOutputStream().write(sb.toString().getBytes("UTF-8"));
    }

    public long getDefaultStartTime() {
        return System.currentTimeMillis() - 604800000L;
    }

    public long getDefaultEndTime() {
        return System.currentTimeMillis() + 604800000L;
    }

    private void addCalendarItem(CalendarItem calItem, Element feed, UserServlet.Context context) throws ServiceException {
        Collection<CalendarItem.Instance> instances = calItem.expandInstances(context.getStartTime(), context.getEndTime(), false);
        for (CalendarItem.Instance inst : instances) {
            InviteInfo invId = inst.getInviteInfo();
            Invite inv = calItem.getInvite(invId.getMsgId(), invId.getComponentId());
            Element entry = feed.addElement("entry");
            entry.addElement("title").setText(inv.getName());
            entry.addElement("updated").setText(DateUtil.toISO8601(new Date(inst.getStart())));
            entry.addElement("summary").setText(inv.getFragment());
            if (!inv.hasOrganizer()) continue;
            Element author = entry.addElement("author");
            author.addElement("name").setText(inv.getOrganizer().getCn());
            author.addElement("email").setText(inv.getOrganizer().getAddress());
        }
    }

    private void addMessage(Message m, Element feed, UserServlet.Context context) {
        Element entry = feed.addElement("entry");
        entry.addElement("title").setText(m.getSubject());
        entry.addElement("summary").setText(m.getFragment());
        Element author = entry.addElement("author");
        author.addElement("name").setText(m.getSender());
        author.addElement("email").setText(m.getSender());
        entry.addElement("modified").setText(DateUtil.toISO8601(new Date(m.getDate())));
    }

    public String getType() {
        return "atom";
    }

    public boolean canBeBlocked() {
        return false;
    }
}

