/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.formatter;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.BufferStream;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Chat;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.DeliveryOptions;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.Task;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.mailbox.calendar.IcsImportParseHandler;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.UserServletException;
import com.zimbra.cs.service.formatter.ContactCSV;
import com.zimbra.cs.service.formatter.Formatter;
import com.zimbra.cs.service.formatter.FormatterServiceException;
import com.zimbra.cs.service.formatter.HeadersOnlyInputStream;
import com.zimbra.cs.service.formatter.VCard;
import com.zimbra.cs.service.formatter.WikiFormatter;
import com.zimbra.cs.service.mail.ImportContacts;
import com.zimbra.cs.service.util.ItemData;
import com.zimbra.cs.service.util.ItemId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveFormatter
extends Formatter {
    private Pattern ILLEGAL_FILE_CHARS = Pattern.compile("[\\/\\:\\*\\?\\\"\\<\\>\\|]");
    private Pattern ILLEGAL_FOLDER_CHARS = Pattern.compile("[\\:\\*\\?\\\"\\<\\>\\|]");
    private static String UTF8 = "UTF-8";

    @Override
    public String getDefaultSearchTypes() {
        return "appointment,contact,document,briefcase,message,note,task,wiki";
    }

    @Override
    public boolean canBeBlocked() {
        return true;
    }

    @Override
    public boolean supportsSave() {
        return true;
    }

    protected boolean getDefaultMeta() {
        return true;
    }

    protected abstract ArchiveInputStream getInputStream(UserServlet.Context var1, String var2) throws IOException, ServiceException, UserServletException;

    protected abstract ArchiveOutputStream getOutputStream(UserServlet.Context var1, String var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void formatCallback(UserServlet.Context context) throws IOException, ServiceException, UserServletException {
        ArchiveOutputStream aos;
        block49: {
            HashMap<Integer, Integer> cnts = new HashMap<Integer, Integer>();
            boolean conversations = false;
            HashMap<Integer, String> fldrs = new HashMap<Integer, String>();
            String emptyname = context.params.get("emptyname");
            String ext = "." + this.getType();
            String filename = context.params.get("filename");
            String lock = context.params.get("lock");
            MailboxManager.MailboxLock ml = null;
            HashSet<String> names = new HashSet<String>(4096);
            String query = context.getQueryString();
            byte[] sysTypes = new byte[]{1, 2, 3, 10, 13};
            byte[] searchTypes = new byte[]{5, 6, 8, 14, 11, 15, 16, 9};
            aos = null;
            String types = context.getTypesString();
            try {
                if (filename == null || filename.equals("")) {
                    Date date = new Date();
                    DateFormat df = DateFormat.getDateInstance(3);
                    SimpleDateFormat sdf = new SimpleDateFormat(".H-m-s");
                    filename = context.hasPart() ? "attachments" : context.targetMailbox.getAccountId() + '.' + df.format(date).replace('/', '-') + sdf.format(date);
                } else {
                    int dot = filename.lastIndexOf(46);
                    if (dot != -1) {
                        ext = filename.substring(dot);
                    }
                }
                if (!filename.endsWith(ext)) {
                    filename = filename + ext;
                }
                if (emptyname != null && !emptyname.equals("") && !emptyname.endsWith(ext)) {
                    emptyname = emptyname + ext;
                }
                context.resp.addHeader("Content-Disposition", "attachment; filename=" + HttpUtil.encodeFilename(context.req, filename));
                if (ext.equals(".tar")) {
                    context.resp.setContentType("application/x-tar");
                } else if (ext.equals(".tgz")) {
                    context.resp.setContentType("application/x-compressed-tar");
                } else if (ext.equals(".zip")) {
                    context.resp.setContentType("application/zip");
                }
                if (types != null && !types.equals("")) {
                    searchTypes = MailboxIndex.parseTypesString(types);
                    Arrays.sort(searchTypes);
                    sysTypes = new byte[]{};
                    if (Arrays.binarySearch(searchTypes, (byte)4) >= 0) {
                        int i = 0;
                        byte[] newTypes = new byte[searchTypes.length - 1];
                        for (byte type : searchTypes) {
                            if (type == 4) continue;
                            newTypes[i++] = type;
                        }
                        conversations = true;
                        searchTypes = newTypes;
                    }
                }
                if (lock != null && (lock.equals("1") || lock.equals("t") || lock.equals("true"))) {
                    ml = MailboxManager.getInstance().beginMaintenance(context.targetMailbox.getAccountId(), context.targetMailbox.getId());
                }
                if (context.respListItems != null) {
                    try {
                        for (MailItem mi : context.respListItems) {
                            aos = this.saveItem(context, mi, fldrs, cnts, names, false, aos);
                        }
                    }
                    catch (Exception e) {
                        this.warn(e);
                    }
                } else if (context.target != null && !(context.target instanceof Folder)) {
                    try {
                        aos = this.saveItem(context, context.target, fldrs, cnts, names, false, aos);
                    }
                    catch (Exception e) {
                        this.warn(e);
                    }
                } else {
                    block47: {
                        Folder f;
                        ZimbraQueryResults results = null;
                        boolean saveTargetFolder = false;
                        if (context.target instanceof Folder && (f = (Folder)context.target).getId() != 1) {
                            conversations = false;
                            saveTargetFolder = true;
                            query = "under:\"" + f.getPath() + "\"" + (query == null ? "" : " " + query);
                        }
                        if (query == null || query.equals("")) {
                            SortPath sp = new SortPath();
                            for (byte type : sysTypes) {
                                List items = context.targetMailbox.getItemList(context.opContext, type);
                                Collections.sort(items, sp);
                                for (MailItem item : items) {
                                    aos = this.saveItem(context, item, fldrs, cnts, names, false, aos);
                                }
                            }
                            if (types == null || types.equals("")) {
                                conversations = true;
                            }
                            query = "is:local";
                        }
                        try {
                            results = context.targetMailbox.search(context.opContext, query, searchTypes, SortBy.NONE, 4096);
                        }
                        catch (ParseException e) {
                            throw ServiceException.PARSE_ERROR(e.getLocalizedMessage(), e);
                        }
                        try {
                            try {
                                while (results.hasNext()) {
                                    if (saveTargetFolder) {
                                        saveTargetFolder = false;
                                        aos = this.saveItem(context, context.target, fldrs, cnts, names, false, aos);
                                    }
                                    aos = this.saveItem(context, results.getNext().getMailItem(), fldrs, cnts, names, false, aos);
                                }
                                if (conversations) {
                                    for (MailItem item : context.targetMailbox.getItemList(context.opContext, (byte)4)) {
                                        aos = this.saveItem(context, item, fldrs, cnts, names, false, aos);
                                    }
                                }
                                Object var28_35 = null;
                                if (results == null) break block47;
                            }
                            catch (Exception e) {
                                this.warn(e);
                                Object var28_36 = null;
                                if (results != null) {
                                    results.doneWithSearchResults();
                                }
                                break block47;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var28_37 = null;
                            if (results == null) throw throwable;
                            results.doneWithSearchResults();
                            throw throwable;
                        }
                        results.doneWithSearchResults();
                    }
                    if (aos == null) {
                        if (emptyname == null) {
                            context.resp.setHeader("Content-Disposition", null);
                            throw new UserServletException(204, "No data found");
                        }
                        context.resp.setHeader("Content-Disposition", "attachment; filename=" + HttpUtil.encodeFilename(context.req, emptyname));
                        aos = this.getOutputStream(context, UTF8);
                    }
                }
                Object var30_39 = null;
                if (ml == null) break block49;
            }
            catch (Throwable throwable) {
                Object var30_40 = null;
                if (ml != null) {
                    MailboxManager.getInstance().endMaintenance(ml, true, true);
                }
                if (aos == null) throw throwable;
                try {
                    aos.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            MailboxManager.getInstance().endMaintenance(ml, true, true);
        }
        if (aos == null) return;
        try {}
        catch (Exception e) {
            return;
        }
        aos.close();
    }

    private ArchiveOutputStream saveItem(UserServlet.Context context, MailItem mi, HashMap<Integer, String> fldrs, HashMap<Integer, Integer> cnts, Set<String> names, boolean version, ArchiveOutputStream aos) throws ServiceException {
        ArchiveOutputEntry aoe;
        long miSize;
        String path;
        byte[] data;
        InputStream is;
        block58: {
            boolean meta;
            String extra;
            String name;
            String ext;
            String charset;
            block57: {
                charset = context.params.get("charset");
                ext = null;
                name = null;
                extra = null;
                Integer fid = mi.getFolderId();
                is = null;
                String metaParam = context.params.get("meta");
                boolean bl = metaParam == null ? this.getDefaultMeta() : (meta = !metaParam.equals("0"));
                if (charset == null) {
                    charset = UTF8;
                }
                if (!version && mi.isTagged(-13)) {
                    for (MailItem rev : context.targetMailbox.getAllRevisions(context.opContext, mi.getId(), mi.getType())) {
                        if (mi.getVersion() == rev.getVersion()) continue;
                        aos = this.saveItem(context, rev, fldrs, cnts, names, true, aos);
                    }
                }
                switch (mi.getType()) {
                    case 11: {
                        Appointment appt = (Appointment)mi;
                        if (!appt.isPublic() && !appt.allowPrivateAccess(context.authAccount, context.isUsingAdminPrivileges())) {
                            return aos;
                        }
                        if (meta) {
                            name = appt.getSubject();
                            ext = "appt";
                            break;
                        }
                        ext = "ics";
                        break;
                    }
                    case 16: {
                        ext = "chat";
                        break;
                    }
                    case 6: {
                        Contact ct = (Contact)mi;
                        name = ct.getFileAsString();
                        if (meta) break;
                        ext = "vcf";
                        break;
                    }
                    case 10: {
                        return aos;
                    }
                    case 1: 
                    case 2: 
                    case 13: {
                        if (mi.getId() == 11) {
                            name = "ROOT";
                            break;
                        }
                        if (mi.getId() == 1) {
                            name = "USER_ROOT";
                            break;
                        }
                        name = mi.getName();
                        break;
                    }
                    case 5: {
                        Message msg = (Message)mi;
                        if (msg.hasCalendarItemInfos()) {
                            HashSet<Integer> calItems = new HashSet<Integer>();
                            Iterator<Message.CalendarItemInfo> it = msg.getCalendarItemInfoIterator();
                            while (it.hasNext()) {
                                calItems.add(it.next().getCalendarItemId());
                            }
                            for (Integer n : calItems) {
                                if (extra == null) {
                                    extra = "calendar=" + n.toString();
                                    continue;
                                }
                                extra = extra + ',' + n.toString();
                            }
                        }
                        ext = "eml";
                        break;
                    }
                    case 9: {
                        ext = "note";
                        break;
                    }
                    case 15: {
                        Task task = (Task)mi;
                        if (!task.isPublic() && !task.allowPrivateAccess(context.authAccount, context.isUsingAdminPrivileges())) {
                            return aos;
                        }
                        ext = "task";
                        break;
                    }
                    case 12: {
                        return aos;
                    }
                    case 14: {
                        ext = "wiki";
                    }
                }
                String fldr = fldrs.get(fid);
                if (fldr == null) {
                    Folder f = mi.getMailbox().getFolderById(context.opContext, fid);
                    cnts.put(fid, 1);
                    fldr = f.getPath();
                    if (fldr.startsWith("/")) {
                        fldr = fldr.substring(1);
                    }
                    fldr = this.ILLEGAL_FOLDER_CHARS.matcher(fldr).replaceAll("_");
                    fldrs.put(fid, fldr);
                } else if (!(mi instanceof Folder)) {
                    int BATCH = 500;
                    int cnt = cnts.get(fid) + 1;
                    cnts.put(fid, cnt);
                    if ((cnt /= 500) > 0) {
                        fldr = fldr + '!' + cnt;
                    }
                }
                data = null;
                path = this.getEntryName(mi, fldr, name, ext, names);
                miSize = mi.getSize();
                if (miSize != 0L || mi.getDigest() == null) break block57;
                ZimbraLog.misc.error("blob db size 0 for item %d", mi.getId());
                ArchiveOutputStream archiveOutputStream = aos;
                Object var33_38 = null;
                ByteUtil.closeStream(is);
                return archiveOutputStream;
            }
            try {
                is = mi.getContentStream();
            }
            catch (Exception exception) {
                ZimbraLog.misc.error("missing blob for item %d: expected %d", mi.getId(), miSize);
                ArchiveOutputStream archiveOutputStream = aos;
                Object var33_39 = null;
                ByteUtil.closeStream(is);
                return archiveOutputStream;
            }
            if (aos == null) {
                aos = this.getOutputStream(context, charset);
            }
            aoe = aos.newOutputEntry(path + ".meta", MailItem.getNameForType(mi), mi.getType(), mi.getDate());
            if (mi instanceof Message && (mi.getFlagBitmask() & 0xFFFFFFF6) != 0) {
                aoe.setUnread();
            }
            if (meta) {
                byte[] byArray = new ItemData(mi, extra).encode();
                aoe.setSize(byArray.length);
                aos.putNextEntry(aoe);
                aos.write(byArray);
                aos.closeEntry();
                break block58;
            }
            if (mi instanceof CalendarItem) {
                HttpUtil.Browser browser = HttpUtil.guessBrowser(context.req);
                CalendarItem calendarItem = (CalendarItem)mi;
                ArrayList<CalendarItem> calItems = new ArrayList<CalendarItem>();
                Collection<CalendarItem.Instance> instances = calendarItem.expandInstances(context.getStartTime(), context.getEndTime(), false);
                boolean needAppleICalHacks = HttpUtil.Browser.APPLE_ICAL.equals((Object)browser);
                boolean useOutlookCompatMode = HttpUtil.Browser.IE.equals((Object)browser);
                OperationContext octxt = new OperationContext(context.authAccount, context.isUsingAdminPrivileges());
                StringWriter writer = new StringWriter();
                if (!instances.isEmpty()) {
                    calItems.add(calendarItem);
                    context.targetMailbox.writeICalendarForCalendarItems(writer, octxt, calItems, useOutlookCompatMode, true, needAppleICalHacks, true);
                    data = writer.toString().getBytes(charset);
                }
                break block58;
            }
            if (mi instanceof Contact) {
                VCard vCard = VCard.formatContact((Contact)mi);
                data = vCard.formatted.getBytes(charset);
                break block58;
            }
            if (!(mi instanceof Message) || !context.hasPart()) break block58;
            MimeMessage mimeMessage = ((Message)mi).getMimeMessage();
            for (String part : context.getPart().split(",")) {
                MimePart mp = Mime.getMimePart((MimePart)mimeMessage, part);
                if (mp == null) {
                    throw MailServiceException.NO_SUCH_PART(part);
                }
                name = Mime.getFilename(mp);
                long sz = mp.getSize();
                if (sz == -1L) {
                    sz = miSize;
                }
                if (name == null) {
                    name = "attachment";
                } else {
                    int dot = name.lastIndexOf(46);
                    if (dot != -1 && dot < name.length() - 1) {
                        ext = name.substring(dot + 1);
                        name = name.substring(0, dot);
                    }
                }
                BufferStream bs = new BufferStream(sz, 0x100000);
                bs.readFrom(mp.getInputStream());
                aoe = aos.newOutputEntry(this.getEntryName(mi, "", name, ext, names), MailItem.getNameForType(mi), mi.getType(), mi.getDate());
                sz = bs.getSize();
                aoe.setSize(sz);
                aos.putNextEntry(aoe);
                bs.copyTo(aos.getOutputStream());
                bs.close();
                aos.closeEntry();
            }
            ArchiveOutputStream archiveOutputStream = aos;
            Object var33_40 = null;
            ByteUtil.closeStream(is);
            return archiveOutputStream;
        }
        try {
            block59: {
                try {
                    aoe = aos.newOutputEntry(path, MailItem.getNameForType(mi), mi.getType(), mi.getDate());
                    if (data != null) {
                        aoe.setSize(data.length);
                        aos.putNextEntry(aoe);
                        aos.write(data);
                        aos.closeEntry();
                        break block59;
                    }
                    if (is == null) break block59;
                    if (context.shouldReturnBody()) {
                        long remain;
                        int n;
                        byte[] byArray = new byte[aos.getRecordSize() * 20];
                        aoe.setSize(miSize);
                        aos.putNextEntry(aoe);
                        for (remain = miSize; remain > 0L && (n = is.read(byArray)) >= 0; remain -= (long)n) {
                            aos.write(byArray, 0, remain < (long)n ? (int)remain : n);
                        }
                        if (remain != 0L) {
                            ZimbraLog.misc.error("mismatched blob size for item %d: expected %d", mi.getId(), miSize);
                            if (remain > 0L) {
                                Arrays.fill(byArray, (byte)32);
                                while (remain > 0L) {
                                    aos.write(byArray, 0, remain < (long)byArray.length ? (int)remain : byArray.length);
                                    remain -= (long)byArray.length;
                                }
                            }
                            aos.closeEntry();
                            aoe = aos.newOutputEntry(path + ".err", MailItem.getNameForType(mi), mi.getType(), mi.getDate());
                            aoe.setSize(0L);
                            aos.putNextEntry(aoe);
                        }
                    } else {
                        byte[] byArray = HeadersOnlyInputStream.getHeaders(is);
                        aoe.setSize(byArray.length);
                        aos.putNextEntry(aoe);
                        aos.write(byArray);
                    }
                    aos.closeEntry();
                }
                catch (Exception e) {
                    throw ServiceException.FAILURE("archive error", e);
                }
            }
            Object var33_41 = null;
        }
        catch (Throwable throwable) {
            Object var33_42 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        return aos;
    }

    protected String getEntryName(MailItem mi, String fldr, String name, String ext, Set<String> names) {
        String path;
        String lpath;
        int counter = 0;
        if ((name == null || name.length() == 0) && (name = mi.getName()).length() == 0 && (name = mi.getSubject()).length() == 0) {
            name = MailItem.getNameForType(mi) + '-' + mi.getId();
        } else if (name.length() > 121) {
            name = name.substring(0, 120);
        }
        if (mi.isTagged(-13)) {
            name = name + String.format("-%05d", mi.getVersion());
        }
        name = this.ILLEGAL_FILE_CHARS.matcher(name).replaceAll("_").trim();
        while (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1).trim();
        }
        do {
            String string = path = fldr.equals("") ? name : fldr + '/' + name;
            if (counter > 0) {
                path = path + String.format("-%02d", counter);
            }
            if (ext != null) {
                path = path + '.' + ext;
            }
            ++counter;
        } while (names.contains(lpath = path.toLowerCase()));
        names.add(lpath);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveCallback(UserServlet.Context context, String contentType, Folder fldr, String file) throws IOException, ServiceException {
        LinkedList<ServiceException> errs;
        Exception ex;
        block52: {
            ex = null;
            ItemData id = null;
            HashMap<String, Integer> digestMap = new HashMap<String, Integer>();
            errs = new LinkedList<ServiceException>();
            HashMap<Object, Folder> fmap = new HashMap<Object, Folder>();
            HashMap<Integer, Integer> idMap = new HashMap<Integer, Integer>();
            long last = System.currentTimeMillis();
            String types = context.getTypesString();
            String charset = context.params.get("charset");
            String resolve = context.params.get("resolve");
            String subfolder = context.params.get("subfolder");
            String timestamp = context.params.get("timestamp");
            String timeout = context.params.get("timeout");
            if (charset == null) {
                charset = UTF8;
            }
            try {
                ArchiveInputStream ais;
                Resolve r;
                int[] ids = null;
                long interval = 45000L;
                Resolve resolve2 = r = resolve == null ? Resolve.Skip : Resolve.valueOf(resolve.substring(0, 1).toUpperCase() + resolve.substring(1).toLowerCase());
                if (timeout != null) {
                    interval = Long.parseLong(timeout);
                }
                byte[] searchTypes = null;
                if (context.reqListIds != null) {
                    ids = (int[])context.reqListIds.clone();
                    Arrays.sort(ids);
                }
                if (types != null && !types.equals("")) {
                    searchTypes = MailboxIndex.parseTypesString(types);
                    Arrays.sort(searchTypes);
                    for (byte type : searchTypes) {
                        if (type != 4) continue;
                        int idx = 0;
                        byte[] newTypes = new byte[searchTypes.length - 1];
                        for (byte t : searchTypes) {
                            if (t == 4) continue;
                            newTypes[idx++] = t;
                        }
                        searchTypes = newTypes;
                        break;
                    }
                }
                try {
                    ais = this.getInputStream(context, charset);
                }
                catch (Exception e) {
                    String string;
                    String filename = context.params.get("uploadName");
                    if (filename == null) {
                        string = "unknown";
                        throw FormatterServiceException.INVALID_FORMAT(string);
                    }
                    string = filename;
                    throw FormatterServiceException.INVALID_FORMAT(string);
                }
                if (subfolder != null && !subfolder.equals("")) {
                    fldr = this.createPath(context, fmap, fldr.getPath() + subfolder, (byte)-1);
                }
                List<Folder> flist = fldr.getSubfolderHierarchy();
                if (r == Resolve.Reset) {
                    for (Folder f : flist) {
                        try {
                            int i;
                            List<Integer> delIds;
                            if (System.currentTimeMillis() - last > interval) {
                                this.updateClient(context, true);
                                last = System.currentTimeMillis();
                            }
                            if (searchTypes == null) {
                                delIds = context.targetMailbox.listItemIds(context.opContext, (byte)-1, f.getId());
                            } else if (Arrays.binarySearch(searchTypes, (byte)4) < 0) {
                                delIds = context.targetMailbox.getItemIds(context.opContext, f.getId()).getIds(searchTypes);
                            } else {
                                byte[] delTypes = new byte[searchTypes.length - 1];
                                i = 0;
                                for (byte type : searchTypes) {
                                    if (type == 4) continue;
                                    delTypes[i++] = type;
                                }
                                delIds = context.targetMailbox.getItemIds(context.opContext, f.getId()).getIds(delTypes);
                            }
                            if (delIds == null) continue;
                            int[] delIdsArray = new int[delIds.size()];
                            i = 0;
                            for (Integer del : delIds) {
                                if (del < 256) continue;
                                delIdsArray[i++] = del;
                            }
                            while (i < delIds.size()) {
                                delIdsArray[i++] = -1;
                            }
                            context.targetMailbox.delete(context.opContext, delIdsArray, (byte)-1, null);
                        }
                        catch (MailServiceException e) {
                            if (e.getCode() == "mail.NO_SUCH_FOLDER") continue;
                            r = Resolve.Replace;
                            this.addError(errs, e);
                        }
                        catch (Exception e) {
                            r = Resolve.Replace;
                            this.addError(errs, FormatterServiceException.UNKNOWN_ERROR(f.getName(), e));
                        }
                    }
                    context.targetMailbox.purge((byte)-1);
                    flist = fldr.getSubfolderHierarchy();
                }
                for (Folder f : flist) {
                    fmap.put(f.getId(), f);
                    fmap.put(f.getPath(), f);
                }
                try {
                    block51: {
                        try {
                            ArchiveInputEntry aie;
                            Boolean meta = false;
                            while ((aie = ais.getNextEntry()) != null) {
                                if (System.currentTimeMillis() - last > interval) {
                                    this.updateClient(context, true);
                                    last = System.currentTimeMillis();
                                }
                                if (aie.getName().startsWith("__MACOSX/")) continue;
                                if (aie.getName().endsWith(".meta")) {
                                    meta = true;
                                    if (id != null) {
                                        this.addItem(context, fldr, fmap, digestMap, idMap, ids, searchTypes, r, id, ais, null, errs);
                                    }
                                    try {
                                        id = new ItemData(ArchiveFormatter.readArchiveEntry(ais, aie));
                                    }
                                    catch (Exception e) {
                                        this.addError(errs, FormatterServiceException.INVALID_FORMAT(aie.getName()));
                                    }
                                    continue;
                                }
                                if (aie.getName().endsWith(".err")) {
                                    this.addError(errs, FormatterServiceException.MISMATCHED_SIZE(aie.getName()));
                                } else if (id == null) {
                                    if (meta.booleanValue()) {
                                        this.addError(errs, FormatterServiceException.MISSING_META(aie.getName()));
                                    } else {
                                        this.addData(context, fldr, fmap, searchTypes, r, timestamp == null || !timestamp.equals("0"), ais, aie, errs);
                                    }
                                } else if (aie.getType() != 0 && id.ud.type != aie.getType() || id.ud.getBlobDigest() != null && aie.getSize() != -1L && id.ud.size != aie.getSize()) {
                                    this.addError(errs, FormatterServiceException.MISMATCHED_META(aie.getName()));
                                } else {
                                    this.addItem(context, fldr, fmap, digestMap, idMap, ids, searchTypes, r, id, ais, aie, errs);
                                }
                                id = null;
                            }
                            if (id == null) break block51;
                            this.addItem(context, fldr, fmap, digestMap, idMap, ids, searchTypes, r, id, ais, null, errs);
                        }
                        catch (Exception e) {
                            if (id == null) {
                                this.addError(errs, FormatterServiceException.UNKNOWN_ERROR(e));
                            } else {
                                this.addError(errs, FormatterServiceException.UNKNOWN_ERROR(id.path, e));
                            }
                            id = null;
                            Object var37_51 = null;
                            if (ais != null) {
                                ais.close();
                            }
                            break block52;
                        }
                    }
                    Object var37_50 = null;
                    if (ais == null) break block52;
                }
                catch (Throwable throwable) {
                    Object var37_52 = null;
                    if (ais == null) throw throwable;
                    ais.close();
                    throw throwable;
                }
                ais.close();
            }
            catch (Exception e) {
                ex = e;
            }
        }
        try {
            this.updateClient(context, ex, errs);
            return;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("Archive formatter failure", e);
        }
    }

    private void addError(List<ServiceException> errs, ServiceException ex) {
        StringBuilder s = new StringBuilder(ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage());
        errs.add(ex);
        if (ex.getArgs() != null) {
            s.append(':');
            for (ServiceException.Argument arg : ex.getArgs()) {
                s.append(' ').append(arg.mName).append('=').append(arg.mValue);
            }
        }
        ZimbraLog.misc.warn(s);
    }

    private Folder createParent(UserServlet.Context context, Map<Object, Folder> fmap, String path, byte view) throws ServiceException {
        String parent = path.substring(0, path.lastIndexOf(47));
        if (parent.equals("")) {
            parent = "/";
        }
        return this.createPath(context, fmap, parent, view);
    }

    private Folder createPath(UserServlet.Context context, Map<Object, Folder> fmap, String path, byte view) throws ServiceException {
        Folder fldr = fmap.get(path);
        if (fldr == null) {
            try {
                fldr = context.targetMailbox.getFolderByPath(context.opContext, path);
            }
            catch (Exception e) {
                fldr = context.targetMailbox.createFolder(context.opContext, path, (byte)0, view);
            }
            fmap.put(fldr.getId(), fldr);
            fmap.put(fldr.getPath(), fldr);
        }
        if (view != -1 && fldr.getDefaultView() != -1 && fldr.getDefaultView() != view && (view != 8 && view != 14 || fldr.getDefaultView() != 8 && fldr.getDefaultView() != 14)) {
            throw FormatterServiceException.INVALID_TYPE(Folder.getNameForType(view), path);
        }
        return fldr;
    }

    private static byte[] readArchiveEntry(ArchiveInputStream ais, ArchiveInputEntry aie) throws IOException {
        byte[] data;
        if (aie == null) {
            return null;
        }
        int dsz = (int)aie.getSize();
        if (dsz == 0) {
            return null;
        }
        if (dsz == -1) {
            data = ByteUtil.getContent(ais.getInputStream(), -1, false);
        } else {
            data = new byte[dsz];
            if (ais.read(data, 0, dsz) != dsz) {
                throw new IOException("archive read err");
            }
        }
        return data;
    }

    private String string(String s) {
        return s == null ? new String() : s;
    }

    private void warn(Exception e) {
        if (e.getCause() == null) {
            ZimbraLog.misc.warn((Object)"Archive Formatter warning: %s", e);
        } else {
            ZimbraLog.misc.warn("Archive Formatter warning: %s: %s", e, e.getCause().toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addItem(UserServlet.Context context, Folder fldr, Map<Object, Folder> fmap, Map<String, Integer> digestMap, Map<Integer, Integer> idMap, int[] ids, byte[] searchTypes, Resolve r, ItemData id, ArchiveInputStream ais, ArchiveInputEntry aie, List<ServiceException> errs) throws MessagingException, ServiceException {
        try {
            mbox = fldr.getMailbox();
            mi = MailItem.constructItem(mbox, id.ud);
            newItem = null;
            oldItem = null;
            oc = context.opContext;
            v0 = root = fldr.getId() == 11 || fldr.getId() == 1 || id.path.startsWith(fldr.getPath() + '/') != false;
            if (ids != null && Arrays.binarySearch(ids, id.ud.id) < 0 || searchTypes != null && Arrays.binarySearch(searchTypes, id.ud.type) < 0) {
                return;
            }
            if (id.ud.getBlobDigest() != null && aie == null) {
                this.addError(errs, FormatterServiceException.MISSING_BLOB(id.path));
                return;
            }
            path = root != false ? id.path : fldr.getPath() + id.path;
            if (path.endsWith("/") && !path.equals("/")) {
                path = path.substring(0, path.length() - 1);
            }
            switch (mi.getType()) {
                case 11: 
                case 15: {
                    ci = (CalendarItem)mi;
                    fldr = this.createPath(context, fmap, path, ci.getType() == 11 ? 11 : 15);
                    if (!root || r != Resolve.Reset) {
                        oldCI = null;
                        try {
                            oldCI = mbox.getCalendarItemByUid(oc, ci.getUid());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (oldCI != null && r == Resolve.Replace) {
                            mbox.delete(oc, oldCI.getId(), oldCI.getType());
                        } else {
                            oldItem = oldCI;
                        }
                    }
                    if (oldItem != null && r == Resolve.Skip) break;
                    ad = ci.getAlarmData();
                    data = ArchiveFormatter.readArchiveEntry(ais, aie);
                    blobMimeMsgMap = data == null ? null : CalendarItem.decomposeBlob(data);
                    defScid = new Mailbox.SetCalendarItemData();
                    exceptionScids = null;
                    invs = ci.getInvites();
                    if (invs == null || invs.length <= 0) break;
                    defScid.mInv = invs[0];
                    if (blobMimeMsgMap != null && (mm = blobMimeMsgMap.get(defScid.mInv.getMailItemId())) != null) {
                        defScid.mPm = new ParsedMessage(mm, mbox.attachmentsIndexingEnabled());
                    }
                    if (invs.length > 1) {
                        exceptionScids = new Mailbox.SetCalendarItemData[invs.length - 1];
                        for (i = 1; i < invs.length; ++i) {
                            scid = new Mailbox.SetCalendarItemData();
                            scid.mInv = invs[i];
                            if (blobMimeMsgMap != null && (mm = blobMimeMsgMap.get(defScid.mInv.getMailItemId())) != null) {
                                scid.mPm = new ParsedMessage(mm, mbox.attachmentsIndexingEnabled());
                            }
                            exceptionScids[i - 1] = scid;
                        }
                    }
                    newItem = mbox.setCalendarItem(oc, oldItem != null && r == Resolve.Modify ? oldItem.getFolderId() : fldr.getId(), ci.getFlagBitmask(), ci.getTagBitmask(), defScid, exceptionScids, ci.getAllReplies(), ad == null ? 0L : ad.getNextAt());
                    break;
                }
                case 16: {
                    chat = (Chat)mi;
                    content = ArchiveFormatter.readArchiveEntry(ais, aie);
                    pm = new ParsedMessage(content, (Long)mi.getDate(), mbox.attachmentsIndexingEnabled());
                    fldr = this.createPath(context, fmap, path, (byte)16);
                    if (root && r != Resolve.Reset) {
                        oldChat = null;
                        try {
                            oldChat = mbox.getChatById(oc, chat.getId());
                            if (oldChat.getFolderId() != fldr.getId()) {
                                oldChat = null;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (oldChat != null && chat.getSender().equals(oldChat.getSender()) && chat.getSubject().equals(oldChat.getSubject())) {
                            if (r == Resolve.Replace) {
                                mbox.delete(oc, oldChat.getId(), oldChat.getType());
                            } else {
                                oldItem = oldChat;
                                if (r == Resolve.Modify) {
                                    newItem = mbox.updateChat(oc, pm, oldItem.getId());
                                }
                            }
                        }
                    }
                    if (oldItem != null) break;
                    newItem = mbox.createChat(oc, pm, fldr.getId(), chat.getFlagBitmask(), chat.getTagString());
                    break;
                }
                case 4: {
                    cv = (Conversation)mi;
                    if (r == Resolve.Reset || r == Resolve.Skip) break;
                    try {
                        oldItem = mbox.getConversationByHash(oc, Mailbox.getHash(cv.getSubject()));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 6: {
                    ct = (Contact)mi;
                    fldr = this.createPath(context, fmap, path, (byte)6);
                    if (root && r != Resolve.Reset) {
                        oldContact = null;
                        try {
                            oldContact = mbox.getContactById(oc, ct.getId());
                            if (oldContact.getFolderId() != fldr.getId()) {
                                oldContact = null;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (oldContact != null) {
                            email = this.string(ct.get("email"));
                            first = this.string(ct.get("firstName"));
                            name = this.string(ct.get("fullName"));
                            oldemail = this.string(oldContact.get("email"));
                            oldfirst = this.string(oldContact.get("firstName"));
                            oldname = this.string(oldContact.get("fullName"));
                            if (email.equals(oldemail) && first.equals(oldfirst) && name.equals(oldname)) {
                                if (r == Resolve.Replace) {
                                    mbox.delete(oc, oldContact.getId(), oldContact.getType());
                                } else {
                                    oldItem = oldContact;
                                    if (r == Resolve.Modify) {
                                        mbox.modifyContact(oc, oldItem.getId(), new ParsedContact(ct.getFields(), ArchiveFormatter.readArchiveEntry(ais, aie)));
                                    }
                                }
                            }
                        }
                    }
                    if (oldItem != null) break;
                    newItem = mbox.createContact(oc, new ParsedContact(ct.getFields(), ArchiveFormatter.readArchiveEntry(ais, aie)), fldr.getId(), ct.getTagString());
                    break;
                }
                case 8: 
                case 14: {
                    doc = (Document)mi;
                    oldDoc = null;
                    oldId = idMap.get(mi.getId());
                    fldr = this.createParent(context, fmap, path, doc.getType() == 8 ? 8 : 14);
                    if (oldId != null) ** GOTO lbl130
                    try {
                        for (Document listDoc : mbox.getDocumentList(oc, fldr.getId())) {
                            if (!doc.getName().equals(listDoc.getName())) continue;
                            oldDoc = listDoc;
                            idMap.put(doc.getId(), oldDoc.getId());
                        }
                        ** GOTO lbl131
                    }
                    catch (Exception e) {}
                    ** GOTO lbl131
lbl130:
                    // 1 sources

                    oldDoc = mbox.getDocumentById(oc, oldId);
lbl131:
                    // 4 sources

                    if (oldDoc != null) {
                        if (r == Resolve.Replace && oldId == null) {
                            mbox.delete(oc, oldDoc.getId(), oldDoc.getType());
                        } else {
                            if (doc.getVersion() < oldDoc.getVersion()) {
                                return;
                            }
                            oldItem = oldDoc;
                            if (doc.getVersion() > oldDoc.getVersion()) {
                                newItem = mbox.addDocumentRevision(oc, oldDoc.getId(), ais.getInputStream(), doc.getCreator(), doc.getName());
                            }
                            if (r != Resolve.Skip) {
                                mbox.setDate(oc, newItem.getId(), doc.getType(), doc.getDate());
                            }
                        }
                    }
                    if (oldItem != null) break;
                    if (mi.getType() == 8) {
                        newItem = mbox.createDocument(oc, fldr.getId(), doc.getName(), doc.getContentType(), doc.getCreator(), ais.getInputStream());
                    } else {
                        wi = (WikiItem)mi;
                        newItem = mbox.createWiki(oc, fldr.getId(), wi.getWikiWord(), wi.getCreator(), ais.getInputStream());
                    }
                    mbox.setDate(oc, newItem.getId(), doc.getType(), doc.getDate());
                    idMap.put(doc.getId(), newItem.getId());
                    break;
                }
                case 10: {
                    return;
                }
                case 1: {
                    aclParam = context.params.get("acl");
                    doACL = aclParam == null || aclParam.equals("0") == false;
                    f = (Folder)mi;
                    acl = f.getACL();
                    oldF = null;
                    view = f.getDefaultView();
                    if (view == 4 || view == 10 || view == 3) break;
                    try {
                        oldF = mbox.getFolderByPath(oc, path);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (oldF != null) {
                        oldItem = oldF;
                        if (r != Resolve.Skip) {
                            if (!f.getUrl().equals(oldF.getUrl())) {
                                mbox.setFolderUrl(oc, oldF.getId(), f.getUrl());
                            }
                            if (doACL) {
                                oldACL = oldF.getACL();
                                if (acl == null && oldACL != null || acl != null && (oldACL == null || !acl.equals(oldACL))) {
                                    mbox.setPermissions(oc, oldF.getId(), acl);
                                }
                            }
                        }
                    }
                    if (oldItem != null) break;
                    fldr = this.createParent(context, fmap, path, (byte)-1);
                    fldr = mbox.createFolder(oc, f.getName(), fldr.getId(), (byte)0, f.getDefaultView(), f.getFlagBitmask(), f.getColor(), f.getUrl());
                    newItem = fldr;
                    if (doACL && acl != null) {
                        mbox.setPermissions(oc, fldr.getId(), acl);
                    }
                    fmap.put(fldr.getId(), fldr);
                    fmap.put(fldr.getPath(), fldr);
                    break;
                }
                case 5: {
                    msg = (Message)mi;
                    oldMsg = null;
                    fldr = this.createPath(context, fmap, path, (byte)5);
                    if (root && r != Resolve.Reset) {
                        try {
                            oldMsg = mbox.getMessageById(oc, msg.getId());
                            if (!msg.getDigest().equals(oldMsg.getDigest()) || oldMsg.getFolderId() != fldr.getId()) {
                                oldMsg = null;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (oldMsg == null) {
                        digestId = digestMap.get(path);
                        if (digestId == null) {
                            digestMap.clear();
                            digestMap.put(path, -1);
                            try {
                                for (MailItem item : mbox.getItemList(oc, (byte)5, fldr.getId())) {
                                    digestMap.put(item.getDigest(), item.getId());
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if ((digestId = digestMap.get(mi.getDigest())) != null) {
                            oldMsg = mbox.getMessageById(oc, digestId);
                            if (!msg.getDigest().equals(oldMsg.getDigest())) {
                                oldMsg = null;
                            }
                        }
                    }
                    if (oldMsg != null) {
                        if (r == Resolve.Replace) {
                            mbox.delete(oc, oldMsg.getId(), oldMsg.getType());
                        } else {
                            oldItem = oldMsg;
                        }
                    }
                    if (oldItem != null) break;
                    opt = new DeliveryOptions().setFolderId(fldr.getId()).setNoICal(true).setFlags(msg.getFlagBitmask()).setTagString(msg.getTagString());
                    newItem = mbox.addMessage(oc, ais.getInputStream(), (int)aie.getSize(), msg.getDate(), opt);
                    break;
                }
                case 13: {
                    mp = (Mountpoint)mi;
                    oldMP = null;
                    try {
                        oldMP = mbox.getItemByPath(oc, path);
                        if (oldMP.getType() == mi.getType()) {
                            oldMP = null;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (oldMP != null) {
                        if (r == Resolve.Modify || r == Resolve.Replace) {
                            mbox.delete(oc, oldMP.getId(), oldMP.getType());
                        } else {
                            oldItem = oldMP;
                        }
                    }
                    if (oldItem != null) break;
                    fldr = this.createParent(context, fmap, path, (byte)-1);
                    newItem = mbox.createMountpoint(context.opContext, fldr.getId(), mp.getName(), mp.getOwnerId(), mp.getRemoteId(), mp.getDefaultView(), mp.getFlagBitmask(), mp.getColor());
                    break;
                }
                case 9: {
                    note = (Note)mi;
                    oldNote = null;
                    fldr = this.createPath(context, fmap, path, (byte)9);
                    try {
                        for (Note listNote : mbox.getNoteList(oc, fldr.getId())) {
                            if (!note.getSubject().equals(listNote.getSubject())) continue;
                            oldNote = listNote;
                            break;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (oldNote != null) {
                        if (r == Resolve.Replace) {
                            mbox.delete(oc, oldNote.getId(), oldNote.getType());
                            break;
                        }
                        oldItem = oldNote;
                        if (r != Resolve.Modify) break;
                        mbox.editNote(oc, oldItem.getId(), new String(ArchiveFormatter.readArchiveEntry(ais, aie), ArchiveFormatter.UTF8));
                        break;
                    }
                    if (oldItem != null) break;
                    newItem = mbox.createNote(oc, new String(ArchiveFormatter.readArchiveEntry(ais, aie), ArchiveFormatter.UTF8), note.getBounds(), note.getColor(), fldr.getId());
                    break;
                }
                case 2: {
                    sf = (SearchFolder)mi;
                    oldSF = null;
                    try {
                        oldSF = mbox.getItemByPath(oc, path);
                        if (oldSF.getType() == mi.getType()) {
                            oldSF = null;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (oldSF != null) {
                        if (r == Resolve.Modify) {
                            mbox.modifySearchFolder(oc, oldSF.getId(), sf.getQuery(), sf.getReturnTypes(), sf.getSortField());
                        } else if (r == Resolve.Replace) {
                            mbox.delete(oc, oldSF.getId(), oldSF.getType());
                        } else {
                            oldItem = oldSF;
                        }
                    }
                    if (oldItem != null) break;
                    fldr = this.createParent(context, fmap, path, (byte)-1);
                    newItem = mbox.createSearchFolder(oc, fldr.getId(), sf.getName(), sf.getQuery(), sf.getReturnTypes(), sf.getSortField(), sf.getFlagBitmask(), sf.getColor());
                    break;
                }
                case 3: {
                    tag = (Tag)mi;
                    try {
                        oldTag = mbox.getTagByName(tag.getName());
                        oldItem = oldTag;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (oldItem != null) break;
                    newItem = mbox.createTag(oc, tag.getName(), tag.getColor());
                    break;
                }
                case 12: {
                    return;
                }
            }
            if (newItem != null) {
                if (mi.getColor() != newItem.getColor()) {
                    mbox.setColor(oc, newItem.getId(), newItem.getType(), mi.getColor());
                }
                if (!id.flags.equals(newItem.getFlagString()) || !id.tags.equals(newItem.getTagString())) {
                    mbox.setTags(oc, newItem.getId(), newItem.getType(), id.flags, id.tags, null);
                }
            } else if (oldItem != null && r == Resolve.Modify) {
                if (mi.getColor() != oldItem.getColor()) {
                    mbox.setColor(oc, oldItem.getId(), oldItem.getType(), mi.getColor());
                }
                if (!id.flags.equals(oldItem.getFlagString()) || !id.tags.equals(oldItem.getTagString())) {
                    mbox.setTags(oc, oldItem.getId(), oldItem.getType(), id.flags, id.tags, null);
                }
            }
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.QUOTA_EXCEEDED") {
                throw e;
            }
            if (r != Resolve.Skip || e.getCode() != "mail.ALREADY_EXISTS") {
                this.addError(errs, e);
            }
        }
        catch (Exception e) {
            this.addError(errs, FormatterServiceException.UNKNOWN_ERROR(id.path, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addData(UserServlet.Context context, Folder fldr, Map<Object, Folder> fmap, byte[] searchTypes, Resolve r, boolean timestamp, ArchiveInputStream ais, ArchiveInputEntry aie, List<ServiceException> errs) throws MessagingException, ServiceException {
        try {
            byte view;
            byte type;
            int defaultFldr;
            String dir;
            String file;
            Mailbox mbox = fldr.getMailbox();
            String name = aie.getName();
            int idx = name.lastIndexOf(47);
            Document newItem = null;
            OperationContext oc = context.opContext;
            if (idx == -1) {
                file = name;
                dir = "";
            } else {
                file = name.substring(idx + 1);
                dir = name.substring(0, idx + 1);
                if (!dir.startsWith("/")) {
                    dir = '/' + dir;
                }
            }
            if (file.length() == 0) {
                return;
            }
            if (file.endsWith(".csv") || file.endsWith(".vcf")) {
                defaultFldr = 7;
                type = 6;
                view = 6;
            } else if (file.endsWith(".eml")) {
                defaultFldr = 2;
                type = 5;
                view = 5;
            } else if (file.endsWith(".ics")) {
                if (dir.startsWith("Tasks/")) {
                    defaultFldr = 15;
                    type = 15;
                    view = 15;
                } else {
                    defaultFldr = 10;
                    type = 11;
                    view = 11;
                }
            } else if (file.endsWith(".wiki")) {
                defaultFldr = 12;
                type = 14;
                view = 14;
            } else {
                defaultFldr = 16;
                type = 8;
                view = 8;
            }
            if (searchTypes != null && Arrays.binarySearch(searchTypes, type) < 0) {
                return;
            }
            if (dir.equals("")) {
                if (fldr.getPath().equals("/")) {
                    fldr = mbox.getFolderById(oc, defaultFldr);
                }
                if (fldr.getDefaultView() != -1 && fldr.getDefaultView() != view && (view != 8 && view != 14 || fldr.getDefaultView() != 8 && fldr.getDefaultView() != 14)) {
                    throw FormatterServiceException.INVALID_TYPE(Folder.getNameForType(view), fldr.getPath());
                }
            } else {
                String s = fldr.getPath();
                if (!s.endsWith("/")) {
                    s = s + '/';
                }
                if (dir.startsWith(s)) {
                    dir = dir.substring(s.length());
                }
                fldr = this.createPath(context, fmap, fldr.getPath() + dir, view);
            }
            switch (type) {
                case 11: 
                case 15: {
                    boolean continueOnError = context.ignoreAndContinueOnError();
                    boolean preserveExistingAlarms = context.preserveAlarms();
                    InputStream is = ais.getInputStream();
                    try {
                        if (aie.getSize() <= (long)LC.calendar_ics_import_full_parse_max_size.intValue()) {
                            List<ZCalendar.ZVCalendar> icals = ZCalendar.ZCalendarBuilder.buildMulti(is, UTF8);
                            IcsImportParseHandler.ImportInviteVisitor visitor = new IcsImportParseHandler.ImportInviteVisitor(oc, fldr, preserveExistingAlarms);
                            Invite.createFromCalendar(context.targetAccount, null, icals, true, continueOnError, visitor);
                        } else {
                            IcsImportParseHandler handler = new IcsImportParseHandler(oc, context.targetAccount, fldr, continueOnError, preserveExistingAlarms);
                            ZCalendar.ZCalendarBuilder.parse(is, UTF8, handler);
                        }
                        Object var28_33 = null;
                    }
                    catch (Throwable throwable) {
                        Object var28_34 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    break;
                }
                case 6: {
                    if (file.endsWith(".csv")) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(ais.getInputStream(), UTF8));
                        ImportContacts.ImportCsvContacts(oc, context.targetMailbox, new ItemId(fldr), ContactCSV.getContacts(reader, null));
                        break;
                    }
                    List<VCard> cards = VCard.parseVCard(new String(ArchiveFormatter.readArchiveEntry(ais, aie), UTF8));
                    if (cards == null || cards.size() == 0 || cards.size() == 1 && cards.get((int)0).fields.isEmpty()) {
                        this.addError(errs, FormatterServiceException.MISSING_VCARD_FIELDS(name));
                        return;
                    }
                    for (VCard vcf : cards) {
                        if (vcf.fields.isEmpty()) continue;
                        mbox.createContact(oc, vcf.asParsedContact(), fldr.getId(), null);
                    }
                    break;
                }
                case 8: 
                case 14: {
                    String creator = context.authAccount == null ? null : context.authAccount.getName();
                    try {
                        MailItem oldItem = mbox.getItemByPath(oc, file, fldr.getId());
                        if (oldItem.getType() != type) {
                            this.addError(errs, FormatterServiceException.MISMATCHED_TYPE(name));
                        } else {
                            if (r == Resolve.Replace) {
                                mbox.delete(oc, oldItem.getId(), type);
                                throw MailServiceException.NO_SUCH_ITEM(oldItem.getId());
                            }
                            if (r != Resolve.Skip) {
                                newItem = mbox.addDocumentRevision(oc, oldItem.getId(), ais.getInputStream(), creator, oldItem.getName());
                            }
                        }
                    }
                    catch (MailServiceException.NoSuchItemException e) {
                        newItem = type == 14 ? mbox.createWiki(oc, fldr.getId(), file, creator, ais.getInputStream()) : mbox.createDocument(oc, fldr.getId(), file, null, creator, ais.getInputStream());
                    }
                    if (newItem == null) break;
                    if (timestamp) {
                        mbox.setDate(oc, newItem.getId(), type, aie.getModTime());
                    }
                    if (type != 14) break;
                    WikiFormatter.expireCacheItem(fldr);
                    break;
                }
                case 5: {
                    int flags = aie.isUnread() ? Flag.BITMASK_UNREAD : 0;
                    DeliveryOptions opt = new DeliveryOptions().setFolderId(fldr.getId()).setNoICal(true).setFlags(flags);
                    mbox.addMessage(oc, ais.getInputStream(), (int)aie.getSize(), timestamp ? aie.getModTime() : -2L, opt);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof MailServiceException && ((MailServiceException)e).getCode() == "mail.QUOTA_EXCEEDED") {
                throw (MailServiceException)e;
            }
            this.addError(errs, FormatterServiceException.UNKNOWN_ERROR(aie.getName(), e));
        }
    }

    public static interface ArchiveOutputStream {
        public void close() throws IOException;

        public void closeEntry() throws IOException;

        public OutputStream getOutputStream();

        public int getRecordSize();

        public ArchiveOutputEntry newOutputEntry(String var1, String var2, int var3, long var4);

        public void putNextEntry(ArchiveOutputEntry var1) throws IOException;

        public void write(byte[] var1) throws IOException;

        public void write(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface ArchiveInputStream {
        public void close() throws IOException;

        public InputStream getInputStream();

        public ArchiveInputEntry getNextEntry() throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface ArchiveOutputEntry {
        public void setUnread();

        public void setSize(long var1);
    }

    public static interface ArchiveInputEntry {
        public long getModTime();

        public String getName();

        public long getSize();

        public int getType();

        public boolean isUnread();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SortPath
    implements Comparator<MailItem> {
        SortPath() {
        }

        @Override
        public int compare(MailItem m1, MailItem m2) {
            try {
                int ret = m1.getPath().compareTo(m2.getPath());
                return ret == 0 ? m1.getName().compareTo(m2.getName()) : ret;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Resolve {
        Modify,
        Replace,
        Reset,
        Skip;

    }
}

