/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.zimlet.ZimletUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndeployZimlet
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = UndeployZimlet.getZimbraSoapContext(context);
        for (Server server : Provisioning.getInstance().getAllServers()) {
            this.checkRight(zsc, context, server, Rights.Admin.R_deployZimlet);
        }
        String name = request.getAttribute("name");
        String action = request.getAttribute("action", null);
        ZAuthToken auth = null;
        if (action == null) {
            auth = zsc.getRawAuthToken();
        }
        Element response = zsc.createElement(AdminConstants.UNDEPLOY_ZIMLET_RESPONSE);
        new Thread(new UndeployThread(name, auth)).start();
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_deployZimlet);
        notes.add("Need the " + Rights.Admin.R_deployZimlet.getName() + " right on all servers.");
    }

    private static class UndeployThread
    implements Runnable {
        String name;
        ZAuthToken auth;

        public UndeployThread(String na, ZAuthToken au) {
            this.name = na;
            this.auth = au;
        }

        public void run() {
            try {
                ZimletUtil.uninstallZimlet(this.name, this.auth);
            }
            catch (Exception e) {
                ZimbraLog.zimlet.info((Object)"undeploy", e);
            }
        }
    }
}

