/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.IDNUtil;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToXML {
    public static Element encodeAccount(Element parent, Account account) {
        return ToXML.encodeAccount(parent, account, true, null, null);
    }

    public static Element encodeAccount(Element parent, Account account, boolean applyCos) {
        return ToXML.encodeAccount(parent, account, applyCos, null, null);
    }

    public static Element encodeAccount(Element parent, Account account, boolean applyCos, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        Element acctElem = parent.addElement("account");
        acctElem.addAttribute("name", account.getUnicodeName());
        acctElem.addAttribute("id", account.getId());
        Map<String, Object> attrs = account.getUnicodeAttrs(applyCos);
        ToXML.encodeAttrs(acctElem, attrs, "n", reqAttrs, attrRightChecker);
        return acctElem;
    }

    public static Element encodeCalendarResource(Element parent, CalendarResource resource) {
        return ToXML.encodeCalendarResource(parent, resource, false, null, null);
    }

    public static Element encodeCalendarResource(Element parent, CalendarResource resource, boolean applyCos) {
        return ToXML.encodeCalendarResource(parent, resource, applyCos, null, null);
    }

    public static Element encodeCalendarResource(Element parent, CalendarResource resource, boolean applyCos, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        Element resElem = parent.addElement("calresource");
        resElem.addAttribute("name", resource.getUnicodeName());
        resElem.addAttribute("id", resource.getId());
        Map<String, Object> attrs = resource.getUnicodeAttrs(applyCos);
        ToXML.encodeAttrs(resElem, attrs, "n", reqAttrs, attrRightChecker);
        return resElem;
    }

    public static void encodeAttrs(Element e, Map attrs, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        ToXML.encodeAttrs(e, attrs, "n", reqAttrs, attrRightChecker);
    }

    private static void encodeAttrs(Element e, Map attrs, String key, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        AttributeManager attrMgr = null;
        try {
            attrMgr = AttributeManager.getInstance();
        }
        catch (ServiceException se) {
            ZimbraLog.account.warn((Object)"failed to get AttributeManager instance", se);
        }
        for (Map.Entry entry : attrs.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (name.equalsIgnoreCase("zimbraDataSourcePassword")) continue;
            if (name.equalsIgnoreCase("userPassword")) {
                value = "VALUE-BLOCKED";
            }
            if (reqAttrs != null && !reqAttrs.contains(name)) continue;
            boolean allowed = attrRightChecker == null ? true : attrRightChecker.allowAttr(name);
            AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, name);
            if (value instanceof String[]) {
                String[] sv = (String[])value;
                for (int i = 0; i < sv.length; ++i) {
                    ToXML.encodeAttr(e, name, sv[i], "a", key, idnType, allowed);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            value = com.zimbra.cs.service.account.ToXML.fixupZimbraPrefTimeZoneId(name, (String)value);
            ToXML.encodeAttr(e, name, (String)value, "a", key, idnType, allowed);
        }
    }

    public static void encodeAttr(Element parent, String key, String value, String eltname, String attrname, AttributeManager.IDNType idnType, boolean allowed) {
        Element e = parent.addElement(eltname);
        e.addAttribute(attrname, key);
        if (allowed) {
            e.setText(IDNUtil.toUnicode(value, idnType));
        } else {
            e.addAttribute("pd", true);
        }
    }
}

