/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.gal.GalImport;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncGalAccount
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SyncGalAccount.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Iterator<Element> accounts = request.elementIterator("account");
        while (accounts.hasNext()) {
            Element account = accounts.next();
            String accountId = account.getAttribute("id");
            Account acct = prov.getAccountById(accountId);
            if (acct == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(accountId);
            }
            Iterator<Element> datasources = account.elementIterator("datasource");
            while (datasources.hasNext()) {
                Element dsElem = datasources.next();
                String by = dsElem.getAttribute("by");
                String name = dsElem.getText();
                DataSource ds = null;
                ds = by.compareTo("id") == 0 ? acct.getDataSourceById(name) : acct.getDataSourceByName(name);
                if (ds == null) {
                    throw AccountServiceException.NO_SUCH_DATA_SOURCE(name);
                }
                if (!ds.getType().equals((Object)DataSource.Type.gal)) continue;
                boolean fullSync = dsElem.getAttributeBool("fullSync", false);
                boolean reset = dsElem.getAttributeBool("reset", false);
                int fid = ds.getFolderId();
                DataSource.DataImport di = DataSourceManager.getInstance().getDataImport(ds);
                if (!(di instanceof GalImport)) continue;
                ((GalImport)di).importGal(fid, reset ? reset : fullSync, reset);
            }
        }
        Element response = zsc.createElement(AdminConstants.SYNC_GAL_ACCOUNT_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("TDB");
    }
}

