/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;

public class StatsImageServlet
extends ZimbraServlet {
    private static Log mLog = LogFactory.getLog(StatsImageServlet.class);
    private static final String IMG_NOT_AVAIL = "data_not_available.gif";

    public void init() throws ServletException {
        String name = this.getServletName();
        mLog.info("Servlet " + name + " starting up");
        super.init();
    }

    public void destroy() {
        String name = this.getServletName();
        mLog.info("Servlet " + name + " shutting down");
        super.destroy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqPath;
        boolean noDefault;
        InputStream is;
        String imgName;
        block22: {
            AuthToken authToken = StatsImageServlet.getAdminAuthTokenFromCookie(req, resp);
            if (authToken == null) {
                return;
            }
            imgName = null;
            is = null;
            boolean imgAvailable = true;
            boolean localServer = false;
            boolean systemWide = false;
            String serverAddr = "";
            String noDefaultImg = req.getParameter("nodef");
            noDefault = false;
            if (noDefaultImg != null && !noDefaultImg.equals("") && noDefaultImg.equals("1")) {
                noDefault = true;
            }
            reqPath = req.getRequestURI();
            try {
                String serviceHostname = Provisioning.getInstance().getLocalServer().getAttr("zimbraServiceHostname");
                String logHost = Provisioning.getInstance().getConfig().getAttr("zimbraLogHostname");
                if (serviceHostname.equalsIgnoreCase(logHost)) break block22;
                StringBuffer url = new StringBuffer("https");
                url.append("://").append(logHost).append(':').append(LC.zimbra_admin_service_port.value());
                url.append(reqPath);
                String queryStr = req.getQueryString();
                if (queryStr != null) {
                    url.append('?').append(queryStr);
                }
                HttpState state = new HttpState();
                try {
                    state.addCookie(new Cookie(logHost, "ZM_ADMIN_AUTH_TOKEN", authToken.getEncoded(), "/", null, false));
                }
                catch (AuthTokenException ate) {
                    throw ServiceException.PROXY_ERROR(ate, url.toString());
                }
                HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
                client.setState(state);
                GetMethod get = new GetMethod(url.toString());
                try {
                    try {
                        int statusCode = client.executeMethod(get);
                        if (statusCode != 200) {
                            throw ServiceException.RESOURCE_UNREACHABLE(get.getStatusText(), null, new ServiceException.Argument[0]);
                        }
                        resp.setContentType("image/gif");
                        ByteUtil.copy(get.getResponseBodyAsStream(), true, (OutputStream)resp.getOutputStream(), false);
                        Object var22_27 = null;
                    }
                    catch (HttpException e) {
                        throw ServiceException.RESOURCE_UNREACHABLE(get.getStatusText(), e, new ServiceException.Argument[0]);
                    }
                    catch (IOException e) {
                        throw ServiceException.RESOURCE_UNREACHABLE(get.getStatusText(), e, new ServiceException.Argument[0]);
                    }
                }
                catch (Throwable throwable) {
                    Object var22_28 = null;
                    get.releaseConnection();
                    throw throwable;
                }
                get.releaseConnection();
                return;
            }
            catch (Exception ex) {
                resp.sendError(404, "Image not found");
                return;
            }
        }
        try {
            if (reqPath == null || reqPath.length() == 0) {
                resp.sendError(400);
                return;
            }
            if (mLog.isDebugEnabled()) {
                mLog.debug("received request to:(" + reqPath + ")");
            }
            String[] reqParts = reqPath.split("/");
            String reqFilename = reqParts[3];
            imgName = LC.stats_img_folder.value() + File.separator + reqFilename;
            try {
                is = new FileInputStream(imgName);
            }
            catch (FileNotFoundException ex) {
                if (is != null) {
                    is.close();
                }
                if (noDefault) {
                    resp.sendError(404, "Image not found");
                    return;
                }
                imgName = LC.stats_img_folder.value() + File.separator + IMG_NOT_AVAIL;
                is = new FileInputStream(imgName);
            }
        }
        catch (Exception ex) {
            if (is != null) {
                is.close();
            }
            resp.sendError(500, "FNF image File not found");
            return;
        }
        resp.setContentType("image/gif");
        ByteUtil.copy(is, true, (OutputStream)resp.getOutputStream(), false);
    }
}

