/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

public abstract class ShareInfoHandler
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    protected NamedEntry getPublishableTargetEntry(ZimbraSoapContext zsc, Element request, Provisioning prov) throws ServiceException {
        Element eDl = request.getElement("dl");
        DistributionList entry = null;
        String key = eDl.getAttribute("by");
        String value = eDl.getText();
        DistributionList dl = prov.get(Provisioning.DistributionListBy.fromString(key), value);
        if (dl == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(value);
        }
        entry = dl;
        return entry;
    }

    protected Account getOwner(ZimbraSoapContext zsc, Element eShare, Provisioning prov, boolean required) throws ServiceException {
        Element eOwner = null;
        eOwner = required ? eShare.getElement("owner") : eShare.getOptionalElement("owner");
        if (eOwner == null) {
            return null;
        }
        String key = eOwner.getAttribute("by");
        String value = eOwner.getText();
        Account account = prov.get(Provisioning.AccountBy.fromString(key), value, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(value);
        }
        return account;
    }
}

