/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.operation.Scheduler;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetThrottle
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = SetThrottle.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        String concurStr = request.getAttribute("concurrency", null);
        if (concurStr != null) {
            int[] params = Scheduler.readOpsFromString(concurStr);
            if (params == null) {
                throw ServiceException.INVALID_REQUEST("Could not parse concurrency string: " + concurStr, null);
            }
            Scheduler.setConcurrency(params);
        }
        Element response = zsc.createElement(AdminConstants.SET_THROTTLE_RESPOSNE);
        Scheduler s = Scheduler.get(null);
        concurStr = "";
        int[] concur = s.getMaxOps();
        for (int i = 0; i < concur.length; ++i) {
            if (i > 0) {
                concurStr = concurStr + ",";
            }
            concurStr = concurStr + concur[i];
        }
        response.addAttribute("concurrency", concurStr);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }
}

