/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPassword
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SetPassword.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        String newPassword = request.getAttribute("newPassword");
        Account account = prov.get(Provisioning.AccountBy.id, id, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        if (account.isCalendarResource()) {
            CalendarResource resource = prov.get(Provisioning.CalendarResourceBy.id, id);
            this.checkCalendarResourceRight(zsc, resource, Rights.Admin.R_setCalendarResourcePassword);
        } else {
            this.checkAccountRight(zsc, account, Rights.Admin.R_setAccountPassword);
        }
        prov.setPassword(account, newPassword);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "SetPassword", "name", account.getName()}));
        Element response = zsc.createElement(AdminConstants.SET_PASSWORD_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_setAccountPassword);
        relatedRights.add(Rights.Admin.R_setCalendarResourcePassword);
    }
}

