/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.gal.GalSearchControl;
import com.zimbra.cs.gal.GalSearchParams;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchGal
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Provisioning.GAL_SEARCH_TYPE type;
        String n = request.getAttribute("name");
        ZimbraSoapContext zsc = SearchGal.getZimbraSoapContext(context);
        Account acct = SearchGal.getRequestedAccount(SearchGal.getZimbraSoapContext(context));
        while (n.endsWith("*")) {
            n = n.substring(0, n.length() - 1);
        }
        String domain = request.getAttribute("domain");
        String typeStr = request.getAttribute("type", "account");
        String token = request.getAttribute("token", null);
        String galAcctId = request.getAttribute("id", null);
        if (typeStr.equals("all")) {
            type = Provisioning.GAL_SEARCH_TYPE.ALL;
        } else if (typeStr.equals("account")) {
            type = Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT;
        } else if (typeStr.equals("resource")) {
            type = Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE;
        } else {
            throw ServiceException.INVALID_REQUEST("Invalid search type: " + typeStr, null);
        }
        Provisioning prov = Provisioning.getInstance();
        Domain d = prov.get(Provisioning.DomainBy.name, domain);
        if (d == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(domain);
        }
        this.checkDomainRight(zsc, d, (Object)Rights.Admin.R_accessGAL);
        GalSearchParams params = new GalSearchParams(d, zsc);
        if (token != null) {
            params.setToken(token);
        }
        params.setType(type);
        params.setRequest(request);
        params.setQuery(n);
        params.setResponseName(AdminConstants.SEARCH_GAL_RESPONSE);
        if (galAcctId != null) {
            params.setGalSyncAccount(Provisioning.getInstance().getAccountById(galAcctId));
        }
        GalSearchControl gal = new GalSearchControl(params);
        if (token != null) {
            gal.sync();
        } else {
            gal.search();
        }
        return params.getResultCallback().getResponse();
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_accessGAL);
    }
}

