/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetCos;
import com.zimbra.cs.service.admin.GetDistributionList;
import com.zimbra.cs.service.admin.GetDomain;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDirectory
extends AdminDocumentHandler {
    public static final String BY_NAME = "name";
    public static final String BY_ID = "id";
    private static final String SEARCH_DIRECTORY_ACCOUNT_DATA = "SearchDirectoryAccount";
    public static final int MAX_SEARCH_RESULTS = 5000;

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int i;
        List accounts;
        ZimbraSoapContext zsc = SearchDirectory.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String query = request.getAttribute("query");
        int maxResults = (int)request.getAttributeLong("maxResults", 5000L);
        int limit = (int)request.getAttributeLong("limit", Integer.MAX_VALUE);
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        int offset = (int)request.getAttributeLong("offset", 0L);
        String domain = request.getAttribute("domain", null);
        boolean applyCos = request.getAttributeBool("applyCos", true);
        boolean applyConfig = request.getAttributeBool("applyConfig", true);
        String attrsStr = request.getAttribute("attrs", null);
        String sortBy = request.getAttribute("sortBy", null);
        String types = request.getAttribute("types", "accounts");
        boolean sortAscending = request.getAttributeBool("sortAscending", true);
        int flags = 0;
        if (types.indexOf("accounts") != -1) {
            flags |= 1;
        }
        if (types.indexOf("aliases") != -1) {
            flags |= 2;
        }
        if (types.indexOf("distributionlists") != -1) {
            flags |= 4;
        }
        if (types.indexOf("resources") != -1) {
            flags |= 8;
        }
        if (types.indexOf("domains") != -1) {
            flags |= 0x10;
        }
        if (types.indexOf("coses") != -1) {
            flags |= 0x20;
        }
        if ((flags & 0x20) == 32 && domain != null) {
            throw ServiceException.INVALID_REQUEST("cannot specify domain with coses flag", null);
        }
        String[] attrs = attrsStr == null ? null : attrsStr.split(",");
        HashSet<String> reqAttrs = attrs == null ? null : new HashSet<String>(Arrays.asList(attrs));
        Element response = zsc.createElement(AdminConstants.SEARCH_DIRECTORY_RESPONSE);
        if (this.isDomainAdminOnly(zsc)) {
            if ((flags & 0x10) == 16) {
                if (query != null && query.length() > 0) {
                    throw ServiceException.PERM_DENIED("cannot search for domains");
                }
                domain = this.getAuthTokenAccountDomain(zsc).getName();
                Domain d = null;
                if (domain != null && (d = prov.get(Provisioning.DomainBy.name, domain)) == null) {
                    throw AccountServiceException.NO_SUCH_DOMAIN(domain);
                }
                GetDomain.encodeDomain(response, d, applyConfig, reqAttrs, null);
                response.addAttribute("more", false);
                response.addAttribute("searchTotal", 1L);
                return response;
            }
            if ((flags & 0x20) == 32) {
                throw ServiceException.PERM_DENIED("cannot search for coses");
            }
            if (domain == null) {
                domain = this.getAuthTokenAccountDomain(zsc).getName();
            } else {
                this.checkDomainRight(zsc, domain, (Object)AdminRight.PR_ALWAYS_ALLOW);
            }
        }
        Domain d = null;
        if (domain != null && (d = prov.get(Provisioning.DomainBy.name, domain)) == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(domain);
        }
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        AdminAccessControl.SearchDirectoryRightChecker rightChecker = new AdminAccessControl.SearchDirectoryRightChecker(aac, prov, reqAttrs);
        AdminSession session = (AdminSession)this.getSession(zsc, Session.Type.ADMIN);
        flags |= 0x100;
        if (session != null) {
            accounts = session.searchAccounts(d, query, attrs, sortBy, sortAscending, flags, offset, maxResults, rightChecker);
        } else {
            Provisioning.SearchOptions options = new Provisioning.SearchOptions();
            options.setDomain(d);
            options.setFlags(flags);
            options.setMaxResults(maxResults);
            options.setQuery(query);
            options.setReturnAttrs(attrs);
            options.setSortAscending(sortAscending);
            options.setSortAttr(sortBy);
            options.setConvertIDNToAscii(true);
            accounts = prov.searchDirectory(options, false);
            accounts = rightChecker.getAllowed(accounts);
        }
        LdapProvisioning ldapProv = null;
        if (prov instanceof LdapProvisioning) {
            ldapProv = (LdapProvisioning)prov;
        }
        int limitMax = offset + limit;
        for (i = offset; i < limitMax && i < accounts.size(); ++i) {
            NamedEntry entry = accounts.get(i);
            boolean applyDefault = true;
            if (entry instanceof Account) {
                applyDefault = applyCos;
                this.setAccountDefaults(ldapProv, (Account)entry);
            } else if (entry instanceof Domain) {
                applyDefault = applyConfig;
            }
            SearchDirectory.encodeEntry(prov, response, entry, applyDefault, reqAttrs, aac);
        }
        response.addAttribute("more", i < accounts.size());
        response.addAttribute("searchTotal", accounts.size());
        return response;
    }

    private void setAccountDefaults(LdapProvisioning ldapProv, Account entry) throws ServiceException {
        if (ldapProv == null) {
            return;
        }
        Boolean isDefaultSet = (Boolean)entry.getCachedData(SEARCH_DIRECTORY_ACCOUNT_DATA);
        if (isDefaultSet == null || isDefaultSet == Boolean.FALSE) {
            ldapProv.setAccountDefaults(entry, 0);
            entry.setCachedData(SEARCH_DIRECTORY_ACCOUNT_DATA, Boolean.TRUE);
        }
    }

    static void encodeEntry(Provisioning prov, Element parent, NamedEntry entry, boolean applyDefault, Set<String> reqAttrs, AdminAccessControl aac) throws ServiceException {
        if (entry instanceof CalendarResource) {
            ToXML.encodeCalendarResource(parent, (CalendarResource)entry, applyDefault, reqAttrs, aac.getAttrRightChecker((CalendarResource)entry));
        } else if (entry instanceof Account) {
            ToXML.encodeAccount(parent, (Account)entry, applyDefault, reqAttrs, aac.getAttrRightChecker((Account)entry));
        } else if (entry instanceof DistributionList) {
            GetDistributionList.encodeDistributionList(parent, (DistributionList)entry, false, reqAttrs, aac.getAttrRightChecker((DistributionList)entry));
        } else if (entry instanceof Alias) {
            SearchDirectory.encodeAlias(parent, prov, (Alias)entry, reqAttrs);
        } else if (entry instanceof Domain) {
            GetDomain.encodeDomain(parent, (Domain)entry, applyDefault, reqAttrs, aac.getAttrRightChecker((Domain)entry));
        } else if (entry instanceof Cos) {
            GetCos.encodeCos(parent, (Cos)entry, reqAttrs, aac.getAttrRightChecker((Cos)entry));
        }
    }

    private static void encodeAlias(Element e, Provisioning prov, Alias a, Set<String> reqAttrs) throws ServiceException {
        Element ealias = e.addElement("alias");
        ealias.addAttribute(BY_NAME, a.getUnicodeName());
        ealias.addAttribute(BY_ID, a.getId());
        ealias.addAttribute("targetName", a.getTargetUnicodeName(prov));
        TargetType tt = a.getTargetType(prov);
        if (tt != null) {
            ealias.addAttribute("type", tt.getCode());
        }
        Map<String, Object> attrs = a.getUnicodeAttrs();
        ToXML.encodeAttrs(ealias, attrs, reqAttrs, null);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getAccount);
        relatedRights.add(Rights.Admin.R_getCalendarResource);
        relatedRights.add(Rights.Admin.R_getDistributionList);
        relatedRights.add(Rights.Admin.R_getDomain);
        relatedRights.add(Rights.Admin.R_getCos);
        relatedRights.add(Rights.Admin.R_listAccount);
        relatedRights.add(Rights.Admin.R_listCalendarResource);
        relatedRights.add(Rights.Admin.R_listDistributionList);
        relatedRights.add(Rights.Admin.R_listDomain);
        relatedRights.add(Rights.Admin.R_listCos);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }
}

