/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCalendarResources
extends AdminDocumentHandler {
    public static final String BY_NAME = "name";
    public static final String BY_ID = "id";

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int i;
        List resources;
        ZimbraSoapContext zsc = SearchCalendarResources.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        int limit = (int)request.getAttributeLong("limit", Integer.MAX_VALUE);
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        int offset = (int)request.getAttributeLong("offset", 0L);
        String domain = request.getAttribute("domain", null);
        boolean applyCos = request.getAttributeBool("applyCos", true);
        String sortBy = request.getAttribute("sortBy", null);
        boolean sortAscending = request.getAttributeBool("sortAscending", true);
        String attrsStr = request.getAttribute("attrs", null);
        String[] attrs = attrsStr == null ? null : attrsStr.split(",");
        EntrySearchFilter filter = com.zimbra.cs.service.account.SearchCalendarResources.parseSearchFilter(request);
        if (this.isDomainAdminOnly(zsc)) {
            if (domain == null) {
                domain = this.getAuthTokenAccountDomain(zsc).getName();
            } else {
                this.checkDomainRight(zsc, domain, (Object)AdminRight.PR_ALWAYS_ALLOW);
            }
        }
        Domain d = null;
        if (domain != null && (d = prov.get(Provisioning.DomainBy.name, domain)) == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(domain);
        }
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        AdminAccessControl.SearchDirectoryRightChecker rightChecker = new AdminAccessControl.SearchDirectoryRightChecker(aac, prov, null);
        AdminSession session = (AdminSession)this.getSession(zsc, Session.Type.ADMIN);
        if (session != null) {
            resources = session.searchCalendarResources(d, filter, attrs, sortBy, sortAscending, offset, rightChecker);
        } else {
            resources = d != null ? prov.searchCalendarResources(d, filter, attrs, sortBy, sortAscending) : prov.searchCalendarResources(filter, attrs, sortBy, sortAscending);
            resources = rightChecker.getAllowed(resources);
        }
        Element response = zsc.createElement(AdminConstants.SEARCH_CALENDAR_RESOURCES_RESPONSE);
        int limitMax = offset + limit;
        for (i = offset; i < limitMax && i < resources.size(); ++i) {
            NamedEntry entry = (NamedEntry)resources.get(i);
            ToXML.encodeCalendarResource(response, (CalendarResource)entry, applyCos, null, aac.getAttrRightChecker((CalendarResource)entry));
        }
        response.addAttribute("more", i < resources.size());
        response.addAttribute("searchTotal", resources.size());
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getCalendarResource);
        relatedRights.add(Rights.Admin.R_listCalendarResource);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }
}

