/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.SearchDirectory;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAccounts
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int i;
        List<NamedEntry> accounts;
        String[] attrs;
        ZimbraSoapContext zsc = SearchAccounts.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String query = request.getAttribute("query");
        int limit = (int)request.getAttributeLong("limit", Integer.MAX_VALUE);
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        int offset = (int)request.getAttributeLong("offset", 0L);
        String domain = request.getAttribute("domain", null);
        boolean applyCos = request.getAttributeBool("applyCos", true);
        String attrsStr = request.getAttribute("attrs", null);
        String sortBy = request.getAttribute("sortBy", null);
        String types = request.getAttribute("types", "accounts");
        boolean sortAscending = request.getAttributeBool("sortAscending", true);
        int flags = Provisioning.searchAccountStringToMask(types);
        String[] stringArray = attrs = attrsStr == null ? null : attrsStr.split(",");
        if (this.isDomainAdminOnly(zsc)) {
            if ((flags & 0x10) == 16) {
                throw ServiceException.PERM_DENIED("can not search for domains");
            }
            if (domain == null) {
                domain = this.getAuthTokenAccountDomain(zsc).getName();
            } else {
                this.checkDomainRight(zsc, domain, (Object)AdminRight.PR_ALWAYS_ALLOW);
            }
        }
        Domain d = null;
        if (domain != null && (d = prov.get(Provisioning.DomainBy.name, domain)) == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(domain);
        }
        AdminAccessControl aac = AdminAccessControl.getAdminAccessControl(zsc);
        AdminAccessControl.SearchDirectoryRightChecker rightChecker = new AdminAccessControl.SearchDirectoryRightChecker(aac, prov, null);
        AdminSession session = (AdminSession)this.getSession(zsc, Session.Type.ADMIN);
        if (session != null) {
            accounts = session.searchAccounts(d, query, attrs, sortBy, sortAscending, flags, offset, 0, rightChecker);
        } else {
            accounts = d != null ? prov.searchAccounts(d, query, attrs, sortBy, sortAscending, flags) : prov.searchAccounts(query, attrs, sortBy, sortAscending, flags);
            accounts = rightChecker.getAllowed(accounts);
        }
        Element response = zsc.createElement(AdminConstants.SEARCH_ACCOUNTS_RESPONSE);
        int limitMax = offset + limit;
        for (i = offset; i < limitMax && i < accounts.size(); ++i) {
            NamedEntry entry = (NamedEntry)accounts.get(i);
            SearchDirectory.encodeEntry(prov, response, entry, applyCos, null, aac);
        }
        response.addAttribute("more", i < accounts.size());
        response.addAttribute("searchTotal", accounts.size());
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getAccount);
        relatedRights.add(Rights.Admin.R_getCalendarResource);
        relatedRights.add(Rights.Admin.R_getDistributionList);
        relatedRights.add(Rights.Admin.R_getDomain);
        relatedRights.add(Rights.Admin.R_listAccount);
        relatedRights.add(Rights.Admin.R_listCalendarResource);
        relatedRights.add(Rights.Admin.R_listDistributionList);
        relatedRights.add(Rights.Admin.R_listDomain);
        notes.add("If the authenticated admin does not have the corresponding list{Entry} right for an entry, the entry is skipped in the getAllXXX/searchXXX/searchDirectoryResponse,  no PERM_DENIED exception will be thrown. Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.");
    }
}

