/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.qa.unittest.ZimbraSuite;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunUnitTests
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = RunUnitTests.getZimbraSoapContext(context);
        Element response = lc.createElement(AdminConstants.RUN_UNIT_TESTS_RESPONSE);
        ArrayList<String> testNames = null;
        Iterator<Element> iter = request.elementIterator("test");
        while (iter.hasNext()) {
            if (testNames == null) {
                testNames = new ArrayList<String>();
            }
            Element e = iter.next();
            testNames.add(e.getText());
        }
        TestListenerAdapter results = testNames == null ? ZimbraSuite.runTestSuite() : ZimbraSuite.runUserTests(testNames);
        Element resultsElement = response.addElement("results");
        int numPassed = 0;
        for (ITestResult result : results.getPassedTests()) {
            Element completedElement = resultsElement.addElement("completed");
            completedElement.addAttribute("name", result.getName());
            double execSeconds = (double)(result.getEndMillis() - result.getStartMillis()) / 1000.0;
            completedElement.addAttribute("execSeconds", String.format("%.2f", execSeconds));
            completedElement.addAttribute("class", result.getTestClass().getName());
            ++numPassed;
        }
        int numFailed = 0;
        for (ITestResult result : results.getFailedTests()) {
            Element failureElement = resultsElement.addElement("failure");
            failureElement.addAttribute("name", result.getName());
            double execSeconds = (double)(result.getEndMillis() - result.getStartMillis()) / 1000.0;
            failureElement.addAttribute("execSeconds", String.format("%.2f", execSeconds));
            if (result.getThrowable() != null) {
                failureElement.setText(result.getThrowable().toString());
            }
            failureElement.addAttribute("class", result.getTestClass().getName());
            ++numFailed;
        }
        response.addAttribute("numExecuted", numPassed + numFailed);
        response.addAttribute("numFailed", numFailed);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }
}

