/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RightDocumentHandler
extends AdminDocumentHandler {
    Entry getTargetEntry(Provisioning prov, Element eTarget, TargetType targetType) throws ServiceException {
        Provisioning.TargetBy targetBy = Provisioning.TargetBy.fromString(eTarget.getAttribute("by"));
        String target = eTarget.getText();
        return TargetType.lookupTarget(prov, targetType, targetBy, target);
    }

    NamedEntry getGranteeEntry(Provisioning prov, Element eGrantee, GranteeType granteeType) throws ServiceException {
        if (!granteeType.allowedForAdminRights()) {
            throw ServiceException.INVALID_REQUEST("unsupported grantee type: " + granteeType.getCode(), null);
        }
        Provisioning.GranteeBy granteeBy = Provisioning.GranteeBy.fromString(eGrantee.getAttribute("by"));
        String grantee = eGrantee.getText();
        return GranteeType.lookupGrantee(prov, granteeType, granteeBy, grantee);
    }

    protected void checkCheckRightRight(ZimbraSoapContext zsc, GranteeType granteeType, Provisioning.GranteeBy granteeBy, String grantee) throws ServiceException {
        NamedEntry granteeEntry = GranteeType.lookupGrantee(Provisioning.getInstance(), granteeType, granteeBy, grantee);
        if (granteeType == GranteeType.GT_USER) {
            RightDocumentHandler.checkRight(zsc, granteeEntry, Rights.Admin.R_checkRightUsr);
        } else if (granteeType == GranteeType.GT_GROUP) {
            RightDocumentHandler.checkRight(zsc, granteeEntry, Rights.Admin.R_checkRightGrp);
        } else {
            throw ServiceException.PERM_DENIED("invalid grantee type for check right:" + granteeType.getCode());
        }
    }

    protected Pair<Boolean, Boolean> parseExpandAttrs(Element request) throws ServiceException {
        String expandAttrs = request.getAttribute("expandAllAttrs", null);
        boolean expandSetAttrs = false;
        boolean expandGetAttrs = false;
        if (expandAttrs != null) {
            String[] eas;
            for (String e : eas = expandAttrs.split(",")) {
                String exp = e.trim();
                if (exp.equals("setAttrs")) {
                    expandSetAttrs = true;
                    continue;
                }
                if (exp.equals("getAttrs")) {
                    expandGetAttrs = true;
                    continue;
                }
                throw ServiceException.INVALID_REQUEST("invalid expandAllAttrs value: " + exp, null);
            }
        }
        return new Pair<Boolean, Boolean>(expandSetAttrs, expandGetAttrs);
    }
}

