/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetDistributionList;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameDistributionList
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = RenameDistributionList.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        String newName = request.getAttribute("newName");
        DistributionList dl = prov.get(Provisioning.DistributionListBy.id, id);
        if (dl == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        this.checkDistributionListRight(zsc, dl, Rights.Admin.R_renameDistributionList);
        this.checkDomainRightByEmail(zsc, newName, Rights.Admin.R_createDistributionList);
        String oldName = dl.getName();
        prov.renameDistributionList(id, newName);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "RenameDistributionList", "name", oldName, "newName", newName}));
        dl = prov.get(Provisioning.DistributionListBy.id, id);
        if (dl == null) {
            throw ServiceException.FAILURE("unable to get distribution list after rename: " + id, null);
        }
        Element response = zsc.createElement(AdminConstants.RENAME_DISTRIBUTION_LIST_RESPONSE);
        GetDistributionList.encodeDistributionList(response, dl);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_renameDistributionList);
        relatedRights.add(Rights.Admin.R_createDistributionList);
    }
}

