/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetCos;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameCos
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = RenameCos.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        String newName = request.getAttribute("newName");
        Cos cos = prov.get(Provisioning.CosBy.id, id);
        if (cos == null) {
            throw AccountServiceException.NO_SUCH_COS(id);
        }
        this.checkRight(lc, context, cos, Rights.Admin.R_renameCos);
        String oldName = cos.getName();
        prov.renameCos(id, newName);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "RenameCos", "name", oldName, "newName", newName}));
        cos = prov.get(Provisioning.CosBy.id, id);
        if (cos == null) {
            throw ServiceException.FAILURE("unabled to get renamed cos: " + id, null);
        }
        Element response = lc.createElement(AdminConstants.RENAME_COS_RESPONSE);
        GetCos.encodeCos(response, cos);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_renameCos);
    }
}

